/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.profiler;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ProfilerSwitch {
    private static final AtomicBoolean enableDetailProfiler = new AtomicBoolean(false);
    private static final AtomicBoolean enableSimpleProfiler = new AtomicBoolean(true);
    private static final AtomicReference<Double> warnPercent = new AtomicReference<Double>(0.75);

    public static void enableSimpleProfiler() {
        enableSimpleProfiler.set(true);
    }

    public static void disableSimpleProfiler() {
        enableSimpleProfiler.set(false);
    }

    public static void enableDetailProfiler() {
        enableDetailProfiler.set(true);
    }

    public static void disableDetailProfiler() {
        enableDetailProfiler.set(false);
    }

    public static boolean isEnableDetailProfiler() {
        return enableDetailProfiler.get() && enableSimpleProfiler.get();
    }

    public static boolean isEnableSimpleProfiler() {
        return enableSimpleProfiler.get();
    }

    public static double getWarnPercent() {
        return warnPercent.get();
    }

    public static void setWarnPercent(double percent) {
        warnPercent.set(percent);
    }
}

