/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.function;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.dubbo.common.function.Predicates;

public interface Streams {
    public static <T, S extends Iterable<T>> Stream<T> filterStream(S values, Predicate<T> predicate) {
        return StreamSupport.stream(values.spliterator(), false).filter(predicate);
    }

    public static <T, S extends Iterable<T>> List<T> filterList(S values, Predicate<T> predicate) {
        return Streams.filterStream(values, predicate).collect(Collectors.toList());
    }

    public static <T, S extends Iterable<T>> Set<T> filterSet(S values, Predicate<T> predicate) {
        return Streams.filterStream(values, predicate).collect(LinkedHashSet::new, Set::add, Set::addAll);
    }

    public static <T, S extends Iterable<T>> S filter(S values, Predicate<T> predicate) {
        boolean isSet = Set.class.isAssignableFrom(values.getClass());
        return (S)(isSet ? Streams.filterSet(values, predicate) : Streams.filterList(values, predicate));
    }

    public static <T, S extends Iterable<T>> S filterAll(S values, Predicate<T> ... predicates) {
        return Streams.filter(values, Predicates.and(predicates));
    }

    public static <T, S extends Iterable<T>> S filterAny(S values, Predicate<T> ... predicates) {
        return Streams.filter(values, Predicates.or(predicates));
    }

    public static <T> T filterFirst(Iterable<T> values, Predicate<T> ... predicates) {
        return StreamSupport.stream(values.spliterator(), false).filter(Predicates.and(predicates)).findFirst().orElse(null);
    }
}

