/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.dubbo.common.config.Configuration;

public class InmemoryConfiguration
implements Configuration {
    private String name;
    private Map<String, String> store = new LinkedHashMap<String, String>();

    public InmemoryConfiguration() {
    }

    public InmemoryConfiguration(String name) {
        this.name = name;
    }

    public InmemoryConfiguration(Map<String, String> properties) {
        this.setProperties(properties);
    }

    @Override
    public Object getInternalProperty(String key) {
        return this.store.get(key);
    }

    public void addProperty(String key, String value) {
        this.store.put(key, value);
    }

    public void addProperties(Map<String, String> properties) {
        if (properties != null) {
            this.store.putAll(properties);
        }
    }

    public void setProperties(Map<String, String> properties) {
        if (properties != null) {
            this.store = properties;
        }
    }

    public Map<String, String> getProperties() {
        return this.store;
    }
}

