/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import java.util.Arrays;
import java.util.List;
import org.apache.shenyu.plugin.mock.api.MockRequest;
import org.apache.shenyu.plugin.mock.generator.Generator;
import org.apache.shenyu.plugin.mock.util.MockUtil;
import org.apache.shenyu.spi.Join;

@Join
public class RangeDataGenerator
implements Generator<String> {
    @Override
    public String getName() {
        return "list";
    }

    @Override
    public String doGenerate(List<String> params, String rule, MockRequest mockRequest) {
        String rangeData = params.get(0).replaceAll("\\[(.+)]", "$1");
        Object[] data = (String[])Arrays.stream(rangeData.split("(?<!\\\\),")).map(_data -> _data.replace("\\,", ",")).toArray(String[]::new);
        return MockUtil.oneOf(data).toString();
    }

    @Override
    public int getParamSize() {
        return 0;
    }

    @Override
    public boolean match(String rule) {
        boolean matches = rule.matches("^list\\|\\[.+]$");
        if (matches) {
            String candidateData = rule.substring(6, rule.length() - 1);
            return !candidateData.matches("^\\s+$");
        }
        return false;
    }

    @Override
    public String[] getPrefixAndSuffix() {
        return new String[]{"\"", "\""};
    }
}

