/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.utils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.plugin.api.exception.ResponsiveException;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRuleHandler;
import org.apache.shenyu.plugin.cryptor.strategy.CryptorStrategyFactory;
import org.apache.shenyu.plugin.cryptor.strategy.MapTypeEnum;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class CryptorUtil {
    private CryptorUtil() {
    }

    public static Mono<Void> fail(String mode, ServerWebExchange exchange) {
        Object error = Optional.ofNullable(mode).filter("decrypt"::equals).map(mod -> ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.DECRYPTION_ERROR)).orElse(ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.ENCRYPTION_ERROR));
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    public static Pair<Boolean, String> checkParam(CryptorRuleHandler ruleHandle) {
        if (StringUtils.isEmpty((CharSequence)ruleHandle.getWay())) {
            return Pair.of((Object)true, (Object)"way");
        }
        if (StringUtils.isEmpty((CharSequence)ruleHandle.getStrategyName())) {
            return Pair.of((Object)true, (Object)"strategyName");
        }
        String fieldNames = ruleHandle.getFieldNames();
        if (StringUtils.isEmpty((CharSequence)fieldNames)) {
            return Pair.of((Object)true, (Object)"fieldNames");
        }
        String mapType = ruleHandle.getMapType();
        if (StringUtils.isEmpty((CharSequence)mapType)) {
            ruleHandle.setMapType(MapTypeEnum.ALL.getMapType());
        }
        if (ruleHandle.getWay().equals("decrypt") && StringUtils.isEmpty((CharSequence)ruleHandle.getDecryptKey())) {
            return Pair.of((Object)true, (Object)"decryptKey");
        }
        if (ruleHandle.getWay().equals("encrypt") && StringUtils.isEmpty((CharSequence)ruleHandle.getEncryptKey())) {
            return Pair.of((Object)true, (Object)"encryptKey");
        }
        if (fieldNames.contains(",") && MapTypeEnum.FIELD.getMapType().equals(mapType)) {
            ruleHandle.setMapType(MapTypeEnum.ALL.getMapType());
        }
        return Pair.of((Object)false, (Object)"");
    }

    public static String crypt(CryptorRuleHandler ruleHandle, String originalData, String originalBody, ServerWebExchange exchange) {
        String modifiedData = CryptorStrategyFactory.match(ruleHandle, originalData);
        if (Objects.isNull(modifiedData)) {
            throw Optional.ofNullable(ruleHandle.getWay()).filter("decrypt"::equals).map(data -> new ResponsiveException(ShenyuResultEnum.DECRYPTION_ERROR, exchange)).orElse(new ResponsiveException(ShenyuResultEnum.ENCRYPTION_ERROR, exchange));
        }
        return MapTypeEnum.mapType(ruleHandle.getMapType()).map(originalBody, modifiedData, ruleHandle.getFieldNames());
    }

    public static String crypt(CryptorRuleHandler ruleHandle, List<Pair<String, String>> pairs, String originalBody, ServerWebExchange exchange) {
        List<Pair<String, String>> modifiedPairs = pairs.stream().map(pair -> Pair.of((Object)((String)pair.getLeft()), (Object)CryptorStrategyFactory.match(ruleHandle, (String)pair.getRight()))).filter(pair -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(CharSequence)pair.getRight()})).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(modifiedPairs)) {
            throw Optional.ofNullable(ruleHandle.getWay()).filter("decrypt"::equals).map(data -> new ResponsiveException(ShenyuResultEnum.DECRYPTION_ERROR, exchange)).orElse(new ResponsiveException(ShenyuResultEnum.ENCRYPTION_ERROR, exchange));
        }
        return MapTypeEnum.mapType(ruleHandle.getMapType()).map(originalBody, modifiedPairs);
    }
}

