/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.handler;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRuleHandler;

public abstract class AbstractCryptorPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, CryptorRuleHandler>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerSelector(SelectorData selectorData) {
        if (!selectorData.getContinued().booleanValue()) {
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"), (Object)CryptorRuleHandler.newInstance());
        }
    }

    public void removeSelector(SelectorData selectorData) {
        CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"));
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            CryptorRuleHandler cryptorRuleHandler = (CryptorRuleHandler)GsonUtils.getInstance().fromJson(s, CryptorRuleHandler.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)cryptorRuleHandler);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }
}

