/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.OptionHelper;
import com.alipay.sofa.common.log.CommonLoggingConfigurations;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.space.SpaceId;
import com.alipay.sofa.common.utils.StringUtil;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.spi.MDCAdapter;

public class LogbackLoggerSpaceFactory
extends AbstractLoggerSpaceFactory {
    private static final Method logContextSetMDCAdapterMethod;
    private final SpaceId spaceId;
    private final LoggerContext loggerContext;
    private final Properties properties;
    private ConsoleAppender<ILoggingEvent> consoleAppender;

    public LogbackLoggerSpaceFactory(SpaceId spaceId, LoggerContext loggerContext, Properties properties, URL confFile, String source) {
        super(source);
        String value;
        this.spaceId = spaceId;
        this.loggerContext = loggerContext;
        this.properties = properties;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            loggerContext.putProperty((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            new ContextInitializer(loggerContext);
            LogbackLoggerSpaceFactory.configureByResource(confFile, loggerContext);
        }
        catch (JoranException e) {
            throw new IllegalStateException("Logback loggerSpaceFactory build error", e);
        }
        if (logContextSetMDCAdapterMethod != null) {
            try {
                logContextSetMDCAdapterMethod.invoke((Object)loggerContext, MDC.getMDCAdapter());
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to invoke setMDCAdapter method", t);
            }
        }
        if (StringUtil.isEmpty(value = properties.getProperty(String.format("sofa.middleware.log.%s.console", spaceId.getSpaceName())))) {
            value = properties.getProperty("sofa.middleware.log.console");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            this.consoleAppender = this.createConsoleAppender();
            loggerContext.addTurboFilter(new TurboFilter(){

                public FilterReply decide(Marker marker, ch.qos.logback.classic.Logger logger, Level level, String format, Object[] params, Throwable t) {
                    if (CommonLoggingConfigurations.shouldAttachConsoleAppender(logger.getName()) && !logger.isAttached(LogbackLoggerSpaceFactory.this.consoleAppender)) {
                        logger.addAppender(LogbackLoggerSpaceFactory.this.consoleAppender);
                    }
                    return FilterReply.NEUTRAL;
                }
            });
        }
    }

    private ConsoleAppender<ILoggingEvent> createConsoleAppender() {
        String pattern;
        ConsoleAppender appender = new ConsoleAppender();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        String logPattern = this.properties.getProperty("sofa.middleware.log.console.logback.pattern", "%d{yyyy-MM-dd HH:mm:ss.SSS} %5p ${PID:- } --- [%15.15t] %-40.40logger{39} : %m%n");
        Level consoleLevel = this.getConsoleLevel(this.spaceId.getSpaceName());
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(consoleLevel.toString());
        try {
            pattern = OptionHelper.substVars((String)logPattern, (PropertyContainer)this.loggerContext);
        }
        catch (ScanException e) {
            throw new IllegalArgumentException("Failed to subst vars pattern: " + logPattern, e);
        }
        encoder.setPattern(pattern);
        encoder.setContext((Context)this.loggerContext);
        encoder.start();
        appender.setEncoder((Encoder)encoder);
        appender.setName("CONSOLE");
        filter.start();
        appender.addFilter((Filter)filter);
        appender.start();
        return appender;
    }

    public SpaceId getSpaceId() {
        return this.spaceId;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private Level getConsoleLevel(String spaceId) {
        String defaultLevel = this.properties.getProperty("sofa.middleware.log.console.level", "INFO");
        String level = this.properties.getProperty(String.format("sofa.middleware.log.%s.console.level", spaceId), defaultLevel);
        return Level.toLevel((String)level, (Level)Level.INFO);
    }

    public Logger getLogger(String name) {
        return this.loggerContext.getLogger(name);
    }

    @Override
    public Logger setLevel(String loggerName, AdapterLevel adapterLevel) {
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)this.getLogger(loggerName);
        Level logbackLevel = this.toLogbackLevel(adapterLevel);
        logbackLogger.setLevel(logbackLevel);
        return logbackLogger;
    }

    private Level toLogbackLevel(AdapterLevel adapterLevel) {
        if (adapterLevel == null) {
            throw new IllegalStateException("AdapterLevel is NULL when adapter to logback.");
        }
        return switch (adapterLevel) {
            case AdapterLevel.TRACE -> Level.TRACE;
            case AdapterLevel.DEBUG -> Level.DEBUG;
            case AdapterLevel.INFO -> Level.INFO;
            case AdapterLevel.WARN -> Level.WARN;
            case AdapterLevel.ERROR -> Level.ERROR;
            default -> throw new IllegalStateException(String.valueOf((Object)adapterLevel) + " is unknown when adapter to logback.");
        };
    }

    public static void configureByResource(URL url, LoggerContext loggerContext) throws JoranException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        String urlString = url.toString();
        if (!urlString.endsWith("xml")) {
            throw new LogbackException("Unexpected filename extension of file [" + String.valueOf(url) + "]. Should be .xml");
        }
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)loggerContext);
        configurator.doConfigure(url);
    }

    static {
        Method logContextSetMDCAdapter;
        try {
            logContextSetMDCAdapter = LoggerContext.class.getDeclaredMethod("setMDCAdapter", MDCAdapter.class);
        }
        catch (Throwable t) {
            logContextSetMDCAdapter = null;
        }
        logContextSetMDCAdapterMethod = logContextSetMDCAdapter;
    }
}

