/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread.virtual;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SofaVirtualThreadFactory {
    public static Thread ofThread(String name, Runnable runnable) {
        return Thread.ofVirtual().name(name).unstarted(runnable);
    }

    public static Thread ofThread(String name, boolean inheritInheritableThreadLocals, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Runnable runnable) {
        return Thread.ofVirtual().name(name).inheritInheritableThreadLocals(inheritInheritableThreadLocals).uncaughtExceptionHandler(uncaughtExceptionHandler).unstarted(runnable);
    }

    public static ExecutorService ofExecutorService(String prefix) {
        return Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name(prefix, 0L).factory());
    }

    public static ExecutorService ofExecutorService(String prefix, long start, boolean inheritInheritableThreadLocals, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        ThreadFactory threadFactory = Thread.ofVirtual().name(prefix, start).inheritInheritableThreadLocals(inheritInheritableThreadLocals).uncaughtExceptionHandler(uncaughtExceptionHandler).factory();
        return Executors.newThreadPerTaskExecutor(threadFactory);
    }
}

