/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandlingResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageHandlingResult.class);
    private final int statusCode;
    private final Object responseBody;
    private final String sessionId;

    public MessageHandlingResult(int statusCode, Object responseBody, String sessionId) {
        this.statusCode = statusCode;
        this.responseBody = responseBody;
        this.sessionId = sessionId;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Object getResponseBody() {
        return this.responseBody;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getResponseBodyAsJson() {
        if (this.responseBody instanceof String) {
            return (String)this.responseBody;
        }
        try {
            return new ObjectMapper().writeValueAsString(this.responseBody);
        }
        catch (Exception e) {
            LOGGER.error("Failed to serialize response body to JSON: {}", (Object)e.getMessage());
            return "{\"jsonrpc\":\"2.0\",\"error\":{\"code\":-32603,\"message\":\"Internal error\"}}";
        }
    }
}

