/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.motan.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RefererConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.proxy.CommonClient;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.convert.plugin.MotanRegisterConfig;
import org.apache.shenyu.common.dto.convert.selector.MotanUpstream;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.DigestUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public final class ApplicationConfigCache {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfigCache.class);
    private static final Map<String, MotanUpstream> UPSTREAM_CACHE_MAP = Maps.newConcurrentMap();
    private RegistryConfig registryConfig;
    private ProtocolConfig protocolConfig;
    private final LoadingCache<String, RefererConfig<CommonClient>> cache = CacheBuilder.newBuilder().maximumSize(1000L).removalListener(notification -> {
        RefererConfig config = (RefererConfig)notification.getValue();
        if (Objects.nonNull(config)) {
            try {
                Field field = FieldUtils.getDeclaredField(config.getClass(), (String)"ref", (boolean)true);
                field.set(config, null);
            }
            catch (IllegalAccessException | NullPointerException e) {
                LOG.error("modify ref have exception", (Throwable)e);
            }
        }
    }).build((CacheLoader)new CacheLoader<String, RefererConfig<CommonClient>>(){

        @NonNull
        public RefererConfig<CommonClient> load(@NonNull String key) {
            return new RefererConfig();
        }
    });

    private ApplicationConfigCache() {
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void init(MotanRegisterConfig motanRegisterConfig) {
        if (Objects.isNull(this.registryConfig)) {
            this.registryConfig = new RegistryConfig();
            this.registryConfig.setId("shenyu_motan_proxy");
            this.registryConfig.setRegister(Boolean.valueOf(false));
        }
        this.registryConfig.setRegProtocol(motanRegisterConfig.getRegisterProtocol());
        this.registryConfig.setAddress(motanRegisterConfig.getRegisterAddress());
        if (Objects.isNull(this.protocolConfig)) {
            this.protocolConfig = new ProtocolConfig();
            this.protocolConfig.setId("motan2");
            this.protocolConfig.setName("motan2");
        }
    }

    public <T> RefererConfig<T> get(String path) {
        try {
            return (RefererConfig)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public RefererConfig<CommonClient> initRef(MetaData metaData) {
        try {
            RefererConfig referenceConfig = (RefererConfig)this.cache.get((Object)metaData.getPath());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getServiceInterface()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("init motan ref ex:{}", (Object)e.getMessage());
        }
        return this.build(metaData);
    }

    public RefererConfig<CommonClient> initRef(String selectorId, MetaData metaData, MotanUpstream motanUpstream) {
        try {
            this.setUpstream(selectorId, motanUpstream);
            RefererConfig referenceConfig = (RefererConfig)this.cache.get((Object)this.generateUpstreamCacheKey(selectorId, metaData.getPath(), motanUpstream));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getServiceInterface()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("init motan ref ex:{}", (Object)e.getMessage());
        }
        return this.build(selectorId, metaData, motanUpstream);
    }

    public RefererConfig<CommonClient> build(MetaData metaData) {
        if (Objects.isNull(this.protocolConfig) || Objects.isNull(this.registryConfig)) {
            return new RefererConfig();
        }
        RefererConfig reference = new RefererConfig();
        reference.setInterface(CommonClient.class);
        reference.setServiceInterface(metaData.getServiceName());
        MotanParamExtInfo motanParamExtInfo = (MotanParamExtInfo)GsonUtils.getInstance().fromJson(metaData.getRpcExt(), MotanParamExtInfo.class);
        reference.setGroup(motanParamExtInfo.getGroup());
        reference.setVersion("1.0");
        reference.setRequestTimeout(Optional.ofNullable(motanParamExtInfo.getTimeout()).orElse(1000));
        reference.setRegistry(this.registryConfig);
        if (StringUtils.isNotEmpty((CharSequence)motanParamExtInfo.getRpcProtocol())) {
            this.protocolConfig.setName(motanParamExtInfo.getRpcProtocol());
            this.protocolConfig.setId(motanParamExtInfo.getRpcProtocol());
        }
        reference.setProtocol(this.protocolConfig);
        CommonClient obj = (CommonClient)reference.getRef();
        if (Objects.nonNull(obj)) {
            LOG.info("init motan reference success there meteData is :{}", (Object)metaData);
            this.cache.put((Object)metaData.getPath(), (Object)reference);
        }
        return reference;
    }

    public RefererConfig<CommonClient> build(String selectorId, MetaData metaData, MotanUpstream motanUpstream) {
        if (Objects.isNull(this.protocolConfig) || Objects.isNull(this.registryConfig)) {
            return new RefererConfig();
        }
        if (Objects.isNull(motanUpstream)) {
            return this.build(metaData);
        }
        RefererConfig reference = new RefererConfig();
        reference.setInterface(CommonClient.class);
        reference.setServiceInterface(metaData.getServiceName());
        MotanParamExtInfo motanParamExtInfo = (MotanParamExtInfo)GsonUtils.getInstance().fromJson(metaData.getRpcExt(), MotanParamExtInfo.class);
        reference.setGroup(motanParamExtInfo.getGroup());
        reference.setVersion("1.0");
        reference.setRequestTimeout(Optional.ofNullable(motanParamExtInfo.getTimeout()).orElse(1000));
        RegistryConfig registryConfig = new RegistryConfig();
        registryConfig.setId("shenyu_motan_proxy");
        registryConfig.setRegister(Boolean.valueOf(false));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{motanUpstream.getRegisterProtocol()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{motanUpstream.getRegisterAddress()})) {
            Optional.ofNullable(motanUpstream.getRegisterProtocol()).ifPresent(arg_0 -> ((RegistryConfig)registryConfig).setRegProtocol(arg_0));
            Optional.ofNullable(motanUpstream.getRegisterAddress()).ifPresent(arg_0 -> ((RegistryConfig)registryConfig).setAddress(arg_0));
        }
        reference.setRegistry(registryConfig);
        if (StringUtils.isNotEmpty((CharSequence)motanParamExtInfo.getRpcProtocol())) {
            this.protocolConfig.setName(motanParamExtInfo.getRpcProtocol());
            this.protocolConfig.setId(motanParamExtInfo.getRpcProtocol());
        }
        reference.setProtocol(this.protocolConfig);
        CommonClient obj = (CommonClient)reference.getRef();
        if (Objects.nonNull(obj)) {
            LOG.info("init motan reference success there meteData is :{}", (Object)metaData);
            this.cache.put((Object)this.generateUpstreamCacheKey(selectorId, metaData.getPath(), motanUpstream), (Object)reference);
        }
        return reference;
    }

    public String generateUpstreamCacheKey(String selectorId, String metaDataPath, MotanUpstream motanUpstream) {
        StringJoiner stringJoiner = new StringJoiner("_");
        stringJoiner.add(selectorId);
        stringJoiner.add(metaDataPath);
        if (StringUtils.isNotBlank((CharSequence)motanUpstream.getProtocol())) {
            stringJoiner.add(motanUpstream.getProtocol());
        }
        if (StringUtils.isNotBlank((CharSequence)motanUpstream.getRegisterAddress())) {
            String registryHash = DigestUtils.md5Hex((String)motanUpstream.getRegisterAddress());
            stringJoiner.add(registryHash);
        }
        return stringJoiner.toString();
    }

    public MotanUpstream getUpstream(String path) {
        return UPSTREAM_CACHE_MAP.get(path);
    }

    public MotanUpstream setUpstream(String path, MotanUpstream motanUpstream) {
        return UPSTREAM_CACHE_MAP.put(path, motanUpstream);
    }

    public void invalidate(String path) {
        this.cache.invalidate((Object)path);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public void invalidateWithMetadataPath(String metadataPath) {
        ConcurrentMap map = this.cache.asMap();
        if (map.isEmpty()) {
            return;
        }
        Set allKeys = map.keySet();
        Set<String> needInvalidateKeys = allKeys.stream().filter(key -> key.contains(metadataPath)).collect(Collectors.toSet());
        if (needInvalidateKeys.isEmpty()) {
            return;
        }
        needInvalidateKeys.forEach(arg_0 -> this.cache.invalidate(arg_0));
    }

    public void invalidateWithSelectorId(String selectorId) {
        ConcurrentMap map = this.cache.asMap();
        if (map.isEmpty()) {
            return;
        }
        Set allKeys = map.keySet();
        Set<String> needInvalidateKeys = allKeys.stream().filter(key -> key.contains(selectorId)).collect(Collectors.toSet());
        if (needInvalidateKeys.isEmpty()) {
            return;
        }
        needInvalidateKeys.forEach(arg_0 -> this.cache.invalidate(arg_0));
    }

    static final class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }

    static class MotanParamExtInfo {
        private List<MethodInfo> methodInfo;
        private String group;
        private Integer timeout;
        private String rpcProtocol;

        MotanParamExtInfo() {
        }

        public List<MethodInfo> getMethodInfo() {
            return this.methodInfo;
        }

        public void setMethodInfo(List<MethodInfo> methodInfo) {
            this.methodInfo = methodInfo;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getRpcProtocol() {
            return this.rpcProtocol;
        }

        public void setRpcProtocol(String rpcProtocol) {
            this.rpcProtocol = rpcProtocol;
        }
    }

    static class MethodInfo {
        private String methodName;
        private List<Pair<String, String>> params;

        MethodInfo() {
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public List<Pair<String, String>> getParams() {
            return this.params;
        }

        public void setParams(List<Pair<String, String>> params) {
            this.params = params;
        }
    }
}

