/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypeInt16;
import com.weibo.breeze.type.TypeInt32;
import com.weibo.breeze.type.TypeString;

public class TypeInt64
implements BreezeType<Long> {
    TypeInt64() {
    }

    public static long readInt64(BreezeBuffer buffer) {
        return buffer.getZigzag64();
    }

    @Override
    public byte getType() {
        return -104;
    }

    @Override
    public Long read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        if (!withType) {
            return TypeInt64.readInt64(buffer);
        }
        byte type = buffer.get();
        if (type <= -105) {
            return type - -120;
        }
        switch (type) {
            case -104: {
                return TypeInt64.readInt64(buffer);
            }
            case 127: {
                return TypeInt32.readInt32(buffer);
            }
            case 63: {
                return Long.parseLong(TypeString.readString(buffer));
            }
            case -98: {
                return TypeInt16.readInt16(buffer);
            }
        }
        throw new BreezeException("Breeze cannot convert to Long. type: " + type);
    }

    @Override
    public void write(BreezeBuffer buffer, Long value, boolean withType) throws BreezeException {
        if (withType) {
            if (value >= -8L && value <= 15L) {
                buffer.put((byte)(value + -120L));
                return;
            }
            buffer.put((byte)-104);
        }
        buffer.putZigzag64(value);
    }

    @Override
    public void writeMessageField(BreezeBuffer buffer, int index, Long field, boolean withType, boolean checkDefault) throws BreezeException {
        if (field != null) {
            if (checkDefault && field == 0L) {
                return;
            }
            buffer.putVarint(index);
            this.write(buffer, field, withType);
        }
    }
}

