/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client;

import io.micrometer.observation.ObservationRegistry;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.DefaultChatClientBuilder;
import org.springframework.ai.chat.client.ResponseEntity;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Media;
import org.springframework.ai.converter.StructuredOutputConverter;
import org.springframework.ai.template.TemplateRenderer;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;

public interface ChatClient {
    public static ChatClient create(ChatModel chatModel) {
        return ChatClient.create(chatModel, ObservationRegistry.NOOP);
    }

    public static ChatClient create(ChatModel chatModel, ObservationRegistry observationRegistry) {
        return ChatClient.create(chatModel, observationRegistry, null);
    }

    public static ChatClient create(ChatModel chatModel, ObservationRegistry observationRegistry, @Nullable ChatClientObservationConvention observationConvention) {
        Assert.notNull((Object)chatModel, (String)"chatModel cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        return ChatClient.builder(chatModel, observationRegistry, observationConvention).build();
    }

    public static Builder builder(ChatModel chatModel) {
        return ChatClient.builder(chatModel, ObservationRegistry.NOOP, null);
    }

    public static Builder builder(ChatModel chatModel, ObservationRegistry observationRegistry, @Nullable ChatClientObservationConvention customObservationConvention) {
        Assert.notNull((Object)chatModel, (String)"chatModel cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        return new DefaultChatClientBuilder(chatModel, observationRegistry, customObservationConvention);
    }

    public ChatClientRequestSpec prompt();

    public ChatClientRequestSpec prompt(String var1);

    public ChatClientRequestSpec prompt(Prompt var1);

    public Builder mutate();

    public static interface Builder {
        public Builder defaultAdvisors(Advisor ... var1);

        public Builder defaultAdvisors(Consumer<AdvisorSpec> var1);

        public Builder defaultAdvisors(List<Advisor> var1);

        public Builder defaultOptions(ChatOptions var1);

        public Builder defaultUser(String var1);

        public Builder defaultUser(Resource var1, Charset var2);

        public Builder defaultUser(Resource var1);

        public Builder defaultUser(Consumer<PromptUserSpec> var1);

        public Builder defaultSystem(String var1);

        public Builder defaultSystem(Resource var1, Charset var2);

        public Builder defaultSystem(Resource var1);

        public Builder defaultSystem(Consumer<PromptSystemSpec> var1);

        public Builder defaultTemplateRenderer(TemplateRenderer var1);

        public Builder defaultToolNames(String ... var1);

        public Builder defaultTools(Object ... var1);

        public Builder defaultToolCallbacks(ToolCallback ... var1);

        public Builder defaultToolCallbacks(List<ToolCallback> var1);

        public Builder defaultToolCallbacks(ToolCallbackProvider ... var1);

        public Builder defaultToolContext(Map<String, Object> var1);

        public Builder clone();

        public ChatClient build();
    }

    public static interface ChatClientRequestSpec {
        public Builder mutate();

        public ChatClientRequestSpec advisors(Consumer<AdvisorSpec> var1);

        public ChatClientRequestSpec advisors(Advisor ... var1);

        public ChatClientRequestSpec advisors(List<Advisor> var1);

        public ChatClientRequestSpec messages(Message ... var1);

        public ChatClientRequestSpec messages(List<Message> var1);

        public <T extends ChatOptions> ChatClientRequestSpec options(T var1);

        public ChatClientRequestSpec toolNames(String ... var1);

        public ChatClientRequestSpec tools(Object ... var1);

        public ChatClientRequestSpec toolCallbacks(ToolCallback ... var1);

        public ChatClientRequestSpec toolCallbacks(List<ToolCallback> var1);

        public ChatClientRequestSpec toolCallbacks(ToolCallbackProvider ... var1);

        public ChatClientRequestSpec toolContext(Map<String, Object> var1);

        public ChatClientRequestSpec system(String var1);

        public ChatClientRequestSpec system(Resource var1, Charset var2);

        public ChatClientRequestSpec system(Resource var1);

        public ChatClientRequestSpec system(Consumer<PromptSystemSpec> var1);

        public ChatClientRequestSpec user(String var1);

        public ChatClientRequestSpec user(Resource var1, Charset var2);

        public ChatClientRequestSpec user(Resource var1);

        public ChatClientRequestSpec user(Consumer<PromptUserSpec> var1);

        public ChatClientRequestSpec templateRenderer(TemplateRenderer var1);

        public CallResponseSpec call();

        public StreamResponseSpec stream();
    }

    public static interface StreamPromptResponseSpec {
        public Flux<ChatResponse> chatResponse();

        public Flux<String> content();
    }

    public static interface CallPromptResponseSpec {
        public String content();

        public List<String> contents();

        public ChatResponse chatResponse();
    }

    public static interface StreamResponseSpec {
        public Flux<ChatClientResponse> chatClientResponse();

        public Flux<ChatResponse> chatResponse();

        public Flux<String> content();
    }

    public static interface CallResponseSpec {
        @Nullable
        public <T> T entity(ParameterizedTypeReference<T> var1);

        @Nullable
        public <T> T entity(StructuredOutputConverter<T> var1);

        @Nullable
        public <T> T entity(Class<T> var1);

        public ChatClientResponse chatClientResponse();

        @Nullable
        public ChatResponse chatResponse();

        @Nullable
        public String content();

        public <T> ResponseEntity<ChatResponse, T> responseEntity(Class<T> var1);

        public <T> ResponseEntity<ChatResponse, T> responseEntity(ParameterizedTypeReference<T> var1);

        public <T> ResponseEntity<ChatResponse, T> responseEntity(StructuredOutputConverter<T> var1);
    }

    public static interface AdvisorSpec {
        public AdvisorSpec param(String var1, Object var2);

        public AdvisorSpec params(Map<String, Object> var1);

        public AdvisorSpec advisors(Advisor ... var1);

        public AdvisorSpec advisors(List<Advisor> var1);
    }

    public static interface PromptSystemSpec {
        public PromptSystemSpec text(String var1);

        public PromptSystemSpec text(Resource var1, Charset var2);

        public PromptSystemSpec text(Resource var1);

        public PromptSystemSpec params(Map<String, Object> var1);

        public PromptSystemSpec param(String var1, Object var2);
    }

    public static interface PromptUserSpec {
        public PromptUserSpec text(String var1);

        public PromptUserSpec text(Resource var1, Charset var2);

        public PromptUserSpec text(Resource var1);

        public PromptUserSpec params(Map<String, Object> var1);

        public PromptUserSpec param(String var1, Object var2);

        public PromptUserSpec media(Media ... var1);

        public PromptUserSpec media(MimeType var1, URL var2);

        public PromptUserSpec media(MimeType var1, Resource var2);
    }
}

