/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.audio.speech;

import java.util.Arrays;
import java.util.Objects;
import org.springframework.ai.model.ModelResult;
import org.springframework.ai.openai.metadata.audio.OpenAiAudioSpeechMetadata;
import org.springframework.lang.Nullable;

public class Speech
implements ModelResult<byte[]> {
    private final byte[] audio;
    private OpenAiAudioSpeechMetadata speechMetadata;

    public Speech(byte[] audio) {
        this.audio = audio;
    }

    public byte[] getOutput() {
        return this.audio;
    }

    public OpenAiAudioSpeechMetadata getMetadata() {
        return this.speechMetadata != null ? this.speechMetadata : OpenAiAudioSpeechMetadata.NULL;
    }

    public Speech withSpeechMetadata(@Nullable OpenAiAudioSpeechMetadata speechMetadata) {
        this.speechMetadata = speechMetadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Speech)) {
            return false;
        }
        Speech that = (Speech)o;
        return Arrays.equals(this.audio, that.audio) && Objects.equals(this.speechMetadata, that.speechMetadata);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.audio), this.speechMetadata);
    }

    public String toString() {
        return "Speech{text=" + String.valueOf(this.audio) + ", speechMetadata=" + String.valueOf(this.speechMetadata) + "}";
    }
}

