/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class OpenAiImageApi {
    public static final String DEFAULT_IMAGE_MODEL = ImageModel.DALL_E_3.getValue();
    private final RestClient restClient;
    private final String imagesPath;

    public OpenAiImageApi(String baseUrl, ApiKey apiKey, MultiValueMap<String, String> headers, String imagesPath, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(h -> {
            if (!(apiKey instanceof NoopApiKey)) {
                h.setBearerAuth(apiKey.getValue());
            }
            h.setContentType(MediaType.APPLICATION_JSON);
            h.addAll(headers);
        }).defaultStatusHandler(responseErrorHandler).build();
        this.imagesPath = imagesPath;
    }

    public ResponseEntity<OpenAiImageResponse> createImage(OpenAiImageRequest openAiImageRequest) {
        Assert.notNull((Object)openAiImageRequest, (String)"Image request cannot be null.");
        Assert.hasLength((String)openAiImageRequest.prompt(), (String)"Prompt cannot be empty.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri(this.imagesPath, new Object[0])).body((Object)openAiImageRequest).retrieve().toEntity(OpenAiImageResponse.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OpenAiImageRequest(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="model") String model, @JsonProperty(value="n") Integer n, @JsonProperty(value="quality") String quality, @JsonProperty(value="response_format") String responseFormat, @JsonProperty(value="size") String size, @JsonProperty(value="style") String style, @JsonProperty(value="user") String user) {
        public OpenAiImageRequest(String prompt, String model) {
            this(prompt, model, null, null, null, null, null, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record OpenAiImageResponse(@JsonProperty(value="created") Long created, @JsonProperty(value="data") List<Data> data) {
    }

    public static class Builder {
        private String baseUrl = "https://api.openai.com";
        private ApiKey apiKey;
        private MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;
        private String imagesPath = "v1/images/generations";

        public Builder baseUrl(String baseUrl) {
            Assert.hasText((String)baseUrl, (String)"baseUrl cannot be null or empty");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder imagesPath(String imagesPath) {
            Assert.hasText((String)imagesPath, (String)"imagesPath cannot be null or empty");
            this.imagesPath = imagesPath;
            return this;
        }

        public Builder apiKey(ApiKey apiKey) {
            Assert.notNull((Object)apiKey, (String)"apiKey cannot be null");
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"simpleApiKey cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder headers(MultiValueMap<String, String> headers) {
            Assert.notNull(headers, (String)"headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"responseErrorHandler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public OpenAiImageApi build() {
            Assert.notNull((Object)this.apiKey, (String)"apiKey must be set");
            return new OpenAiImageApi(this.baseUrl, this.apiKey, this.headers, this.imagesPath, this.restClientBuilder, this.responseErrorHandler);
        }
    }

    public static enum ImageModel {
        DALL_E_3("dall-e-3"),
        DALL_E_2("dall-e-2");

        private final String value;

        private ImageModel(String model) {
            this.value = model;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Data(@JsonProperty(value="url") String url, @JsonProperty(value="b64_json") String b64Json, @JsonProperty(value="revised_prompt") String revisedPrompt) {
    }
}

