/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.common.spring.ai.factory;

import java.util.Optional;
import org.apache.shenyu.common.enums.AiModelProviderEnum;
import org.apache.shenyu.plugin.ai.common.config.AiCommonConfig;
import org.apache.shenyu.plugin.ai.common.spring.ai.AiModelFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.deepseek.DeepSeekChatModel;
import org.springframework.ai.deepseek.DeepSeekChatOptions;
import org.springframework.ai.deepseek.api.DeepSeekApi;

public class DeepSeekModelFactory
implements AiModelFactory {
    private static final AiModelProviderEnum MODEL_PROVIDER_ENUM = AiModelProviderEnum.DEEP_SEEK;

    @Override
    public ChatModel createAiModel(AiCommonConfig config) {
        DeepSeekApi deepSeekApi = DeepSeekApi.builder().baseUrl(config.getBaseUrl()).apiKey(config.getApiKey()).build();
        DeepSeekChatOptions.Builder model = DeepSeekChatOptions.builder().model(config.getModel());
        Optional.ofNullable(config.getTemperature()).ifPresent(arg_0 -> ((DeepSeekChatOptions.Builder)model).temperature(arg_0));
        Optional.ofNullable(config.getMaxTokens()).ifPresent(arg_0 -> ((DeepSeekChatOptions.Builder)model).maxTokens(arg_0));
        return DeepSeekChatModel.builder().deepSeekApi(deepSeekApi).defaultOptions(model.build()).build();
    }

    @Override
    public boolean supports(AiModelProviderEnum modelType) {
        return MODEL_PROVIDER_ENUM.equals((Object)modelType);
    }
}

