/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.internal;

import java.util.concurrent.Executor;
import shade.polaris.com.google.common.annotations.VisibleForTesting;
import shade.polaris.com.google.common.base.Preconditions;
import shade.polaris.com.google.common.util.concurrent.ListenableFuture;
import shade.polaris.com.google.common.util.concurrent.SettableFuture;
import shade.polaris.io.grpc.CallOptions;
import shade.polaris.io.grpc.ClientStreamTracer;
import shade.polaris.io.grpc.InternalChannelz;
import shade.polaris.io.grpc.InternalLogId;
import shade.polaris.io.grpc.Metadata;
import shade.polaris.io.grpc.MethodDescriptor;
import shade.polaris.io.grpc.Status;
import shade.polaris.io.grpc.internal.ClientStream;
import shade.polaris.io.grpc.internal.ClientStreamListener;
import shade.polaris.io.grpc.internal.ClientTransport;
import shade.polaris.io.grpc.internal.FailingClientStream;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

