/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.configuration.client.internal.RetryPolicy;
import java.util.concurrent.TimeUnit;

public class ExponentialRetryPolicy
implements RetryPolicy {
    private final long delayMinTime;
    private final long delayMaxTime;
    private long currentDelayTime;

    public ExponentialRetryPolicy(long delayMinTime, long delayMaxTime) {
        this.delayMinTime = delayMinTime;
        this.delayMaxTime = delayMaxTime;
    }

    @Override
    public void success() {
        this.currentDelayTime = 0L;
    }

    @Override
    public void fail() {
        long delayTime = this.currentDelayTime;
        delayTime = delayTime == 0L ? this.delayMinTime : Math.min(this.currentDelayTime << 1, this.delayMaxTime);
        this.currentDelayTime = delayTime;
    }

    @Override
    public long getCurrentDelayTime() {
        return this.currentDelayTime;
    }

    @Override
    public void executeDelay() {
        try {
            TimeUnit.SECONDS.sleep(this.currentDelayTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

