/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.compose;

import com.tencent.polaris.api.config.global.ClusterConfig;
import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.ServiceKey;
import java.util.Collections;
import java.util.List;

public class ServerServiceInfo {
    private final ServiceKey serviceKey;
    private final ClusterType clusterType;
    private final long refreshIntervalMs;
    private final List<String> routers;
    private final String lbPolicy;

    public ServerServiceInfo(ClusterType clusterType, ClusterConfig clusterConfig) throws PolarisException {
        this.clusterType = clusterType;
        this.serviceKey = new ServiceKey(clusterConfig.getNamespace(), clusterConfig.getService());
        this.refreshIntervalMs = clusterConfig.getRefreshInterval();
        this.routers = Collections.unmodifiableList(clusterConfig.getRouters());
        this.lbPolicy = clusterConfig.getLbPolicy();
    }

    public ClusterType getClusterType() {
        return this.clusterType;
    }

    public long getRefreshIntervalMs() {
        return this.refreshIntervalMs;
    }

    public ServiceKey getServiceKey() {
        return this.serviceKey;
    }

    public List<String> getRouters() {
        return this.routers;
    }

    public String getLbPolicy() {
        return this.lbPolicy;
    }

    public String toString() {
        return "ServerServiceInfo{serviceKey=" + this.serviceKey + '}';
    }
}

