/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.query;

import com.qq.tars.client.Communicator;
import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.util.ParseTools;
import com.qq.tars.common.support.Holder;
import com.qq.tars.support.query.prx.EndpointF;
import com.qq.tars.support.query.prx.QueryFPrx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class QueryHelper {
    private final Communicator communicator;

    public QueryHelper(Communicator communicator) {
        this.communicator = communicator;
    }

    public List<EndpointF> findObjectById(String objName) {
        return this.getPrx().findObjectById(objName);
    }

    private QueryFPrx getPrx() {
        return this.communicator.stringToProxy(QueryFPrx.class, this.communicator.getCommunicatorConfig().getLocator());
    }

    public String getServerNodes(ServantProxyConfig config) {
        QueryFPrx queryProxy = this.getPrx();
        String name = config.getSimpleObjectName();
        Holder<List<EndpointF>> activeEp = new Holder<List<EndpointF>>(new ArrayList());
        Holder<List<EndpointF>> inactiveEp = new Holder<List<EndpointF>>(new ArrayList());
        int ret = 0;
        ret = config.isEnableSet() ? queryProxy.findObjectByIdInSameSet(name, config.getSetDivision(), activeEp, inactiveEp) : queryProxy.findObjectByIdInSameGroup(name, activeEp, inactiveEp);
        if (ret != 0) {
            return null;
        }
        Collections.sort(activeEp.getValue());
        StringBuilder value = new StringBuilder();
        if (activeEp.value != null && !((List)activeEp.value).isEmpty()) {
            for (EndpointF endpointF : (List)activeEp.value) {
                if (value.length() > 0) {
                    value.append(":");
                }
                value.append(ParseTools.toFormatString(endpointF, true));
            }
        }
        if (value.length() < 1) {
            return null;
        }
        value.insert(0, "@");
        value.insert(0, name);
        return value.toString();
    }
}

