/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.cluster;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.cluster.ServantInvokerAliveChecker;
import com.qq.tars.client.cluster.ServantInvokerAliveStat;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.rpc.common.InvokeContext;
import com.qq.tars.rpc.common.Invoker;
import com.qq.tars.rpc.common.exc.NoInvokerException;
import com.qq.tars.support.log.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

@Deprecated
public class DefaultLoadBalance {
    private static final Logger logger = LoggerFactory.getClientLogger();
    private final AtomicInteger sequence = new AtomicInteger();
    private volatile ServantProxyConfig config;
    private final InvokerComparator comparator = new InvokerComparator();

    public DefaultLoadBalance(ServantProxyConfig config) {
        this.config = config;
    }

    public <T> Invoker<T> select(Collection<Invoker<T>> invokers, InvokeContext context) throws NoInvokerException {
        if (logger.isDebugEnabled()) {
            logger.debug("{} try to select active invoker, size= {} ", (Object)this.config.getSimpleObjectName(), (Object)(invokers == null || invokers.isEmpty() ? 0 : invokers.size()));
        }
        if (invokers == null || invokers.isEmpty()) {
            throw new NoInvokerException("no such active connection invoker");
        }
        ArrayList<Invoker<T>> list = new ArrayList<Invoker<T>>();
        for (Invoker<T> invoker : invokers) {
            if (!invoker.isAvailable()) {
                ServantInvokerAliveStat stat = ServantInvokerAliveChecker.get(invoker.getUrl());
                if (!stat.isAlive() && stat.getLastRetryTime() + (long)(this.config.getTryTimeInterval() * 1000) >= System.currentTimeMillis()) continue;
                list.add(invoker);
                continue;
            }
            list.add(invoker);
        }
        if (list.isEmpty()) {
            throw new NoInvokerException(this.config.getSimpleObjectName() + " try to select active invoker, size=" + invokers.size() + ", no such active connection invoker");
        }
        Invoker invoker = null;
        long hash = Math.abs(StringUtils.convertLong(context.getAttachment("tars_hash"), 0L));
        if (hash > 0L) {
            list.sort(this.comparator);
            invoker = (Invoker)list.get((int)(hash % (long)list.size()));
        } else {
            invoker = (Invoker)list.get((this.sequence.getAndIncrement() & Integer.MAX_VALUE) % list.size());
        }
        if (!invoker.isAvailable()) {
            logger.info("try to use inactive invoker|" + invoker.getUrl().toIdentityString());
            ServantInvokerAliveChecker.get(invoker.getUrl()).setLastRetryTime(System.currentTimeMillis());
        }
        return invoker;
    }

    private class InvokerComparator
    implements Comparator<Invoker<?>> {
        private InvokerComparator() {
        }

        @Override
        public int compare(Invoker<?> o1, Invoker<?> o2) {
            return o1.getUrl().compareTo(o2.getUrl());
        }
    }
}

