/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.convert.rule.impl.GrpcRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.grpc.cache.GrpcClientCache;
import org.apache.shenyu.plugin.grpc.resolver.ShenyuServiceInstanceLists;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public final class ApplicationConfigCache {
    private final Supplier<CommonHandleCache<String, List<GrpcUpstream>>> grpcUpstreamCachedHandle = new BeanHolder(CommonHandleCache::new);
    private final Supplier<CommonHandleCache<String, GrpcRuleHandle>> ruleCachedHandle = new BeanHolder(CommonHandleCache::new);
    private final LoadingCache<String, ShenyuServiceInstanceLists> cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, ShenyuServiceInstanceLists>(){

        @NonNull
        public ShenyuServiceInstanceLists load(@NonNull String key) {
            return new ShenyuServiceInstanceLists(key);
        }
    });
    private final Map<String, Consumer<Object>> watchUpstreamListener = new ConcurrentHashMap<String, Consumer<Object>>();

    private ApplicationConfigCache() {
    }

    public ShenyuServiceInstanceLists get(String contextPath) {
        try {
            return (ShenyuServiceInstanceLists)this.cache.get((Object)contextPath);
        }
        catch (ExecutionException e) {
            throw new ShenyuException(e.getCause());
        }
    }

    public void handlerUpstream(String selectorId, List<GrpcUpstream> upstreamList) {
        if (CollectionUtils.isEmpty(upstreamList)) {
            this.invalidate(selectorId);
            return;
        }
        this.grpcUpstreamCachedHandle.get().cachedHandle((Object)selectorId, upstreamList);
        Consumer<Object> consumer = this.watchUpstreamListener.get(selectorId);
        if (Objects.nonNull(consumer)) {
            consumer.accept(System.currentTimeMillis());
        }
    }

    public void invalidate(String selectorId) {
        this.grpcUpstreamCachedHandle.get().removeHandle((Object)selectorId);
        this.cache.invalidate((Object)selectorId);
        this.watchUpstreamListener.remove(selectorId);
        this.ruleCachedHandle.get().removeHandle((Object)CacheKeyUtils.INST.getKey(selectorId, "default_rule"));
        GrpcClientCache.removeClient(selectorId);
    }

    public void watch(String key, Consumer<Object> consumer) {
        this.watchUpstreamListener.put(key, consumer);
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void cacheRuleHandle(String ruleDataKey, String ruleHandle) {
        String handler = StringUtils.hasText((String)ruleHandle) ? ruleHandle : "{}";
        this.ruleCachedHandle.get().cachedHandle((Object)ruleDataKey, (Object)((GrpcRuleHandle)GsonUtils.getInstance().fromJson(handler, GrpcRuleHandle.class)));
    }

    public GrpcRuleHandle getCacheRuleHandle(String ruleDataKey) {
        return (GrpcRuleHandle)this.ruleCachedHandle.get().obtainHandle((Object)ruleDataKey);
    }

    public void removeRuleHandle(String ruleDataKey) {
        this.ruleCachedHandle.get().removeHandle((Object)ruleDataKey);
    }

    public List<GrpcUpstream> getGrpcUpstreamListCache(String selectorId) {
        return (List)this.grpcUpstreamCachedHandle.get().obtainHandle((Object)selectorId);
    }

    static final class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

