/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.exception.WebI18nException;
import org.springframework.util.CollectionUtils;

public final class WebI18nAssert {
    private WebI18nAssert() {
    }

    public static void notNull(Object obj, String message, Object ... objects) {
        WebI18nAssert.isTrue(Objects.nonNull(obj), message, objects);
    }

    public static void isNull(Object obj, String message, Object ... objects) {
        WebI18nAssert.isTrue(Objects.isNull(obj), message, objects);
    }

    public static void notBlack(String str, String message, Object ... objects) {
        WebI18nAssert.isTrue(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{str}), message, objects);
    }

    public static void notEmpty(Collection<?> collection, String message, Object ... objects) {
        WebI18nAssert.isTrue(!CollectionUtils.isEmpty(collection), message, objects);
    }

    public static void isTrue(Boolean test, String message, Object ... objects) {
        if (!Boolean.TRUE.equals(test)) {
            WebI18nAssert.fail(message, objects);
        }
    }

    public static void fail(String message, Object ... objects) {
        throw new WebI18nException(message, objects);
    }
}

