/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.exception.ResourceNotFoundException;
import org.apache.shenyu.admin.exception.ValidFailException;
import org.springframework.util.CollectionUtils;

public final class Assert {
    private Assert() {
    }

    public static void notNull(Object obj, String message) {
        Assert.isTrue(Objects.nonNull(obj), message);
    }

    public static void isNull(Object obj, String message) {
        Assert.isTrue(Objects.isNull(obj), message);
    }

    public static void notBlack(String str, String message) {
        Assert.isTrue(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{str}), message);
    }

    public static void notEmpty(Collection<?> collection, String message) {
        Assert.isTrue(!CollectionUtils.isEmpty(collection), message);
    }

    public static void isTrue(Boolean test, String message) {
        if (!Boolean.TRUE.equals(test)) {
            throw new ValidFailException(message);
        }
    }

    public static void throwException(Exception e) {
        throw new ResourceNotFoundException("the validation ExistProviderMethod invoked error", e);
    }
}

