/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import org.apache.shenyu.admin.listener.AbstractNodeDataChangedListener;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosDataChangedListener
extends AbstractNodeDataChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(NacosDataChangedListener.class);
    private final ConfigService configService;

    public NacosDataChangedListener(ConfigService configService) {
        super(new AbstractNodeDataChangedListener.ChangeData("plugin", "selector", "rule", "auth", "meta", "proxy.selector", "discovery"));
        this.configService = configService;
    }

    public void doPublishConfig(String dataId, Object data) {
        try {
            this.configService.publishConfig(dataId, "DEFAULT_GROUP", GsonUtils.getInstance().toJson(data), ConfigType.JSON.getType());
        }
        catch (NacosException e) {
            LOG.error("Publish data to nacos error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    public void doDelConfig(String dataId) {
        try {
            this.configService.removeConfig(dataId, "DEFAULT_GROUP");
        }
        catch (NacosException e) {
            LOG.error("Publish data to nacos error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    public String getConfig(String dataId) {
        try {
            return this.configService.getConfig(dataId, "DEFAULT_GROUP", 6000L);
        }
        catch (NacosException e) {
            LOG.error("Get data from nacos error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }
}

