/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import com.google.common.base.Preconditions;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNameResolver
extends NameResolver {
    public static final int ETCD_CLIENT_PORT = 2379;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNameResolver.class);
    private final Object lock = new Object();
    private final String authority;
    private final URI targetUri;
    private volatile boolean shutdown;
    private volatile boolean resolving;
    private Executor executor;
    private NameResolver.Listener listener;

    public AbstractNameResolver(URI targetUri) {
        this.targetUri = targetUri;
        this.authority = targetUri.getAuthority() != null ? targetUri.getAuthority() : "";
    }

    public URI getTargetUri() {
        return this.targetUri;
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(NameResolver.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
            this.executor = (Executor)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
            this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
            this.resolve();
        }
    }

    public final synchronized void refresh() {
        this.resolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.executor != null) {
                this.executor = (Executor)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR, (Object)this.executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.executor.execute(this::doResolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResolve() {
        NameResolver.Listener savedListener;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.resolving = true;
            savedListener = this.listener;
        }
        try {
            List<EquivalentAddressGroup> groups = this.computeAddressGroups();
            if (groups.isEmpty()) {
                throw EtcdExceptionFactory.newEtcdException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unable to resolve endpoint " + this.targetUri));
            }
            savedListener.onAddresses(groups, Attributes.EMPTY);
        }
        catch (Exception e) {
            LOGGER.warn("Error wile getting list of servers", (Throwable)e);
            savedListener.onError(Status.NOT_FOUND);
        }
        finally {
            this.resolving = false;
        }
    }

    protected abstract List<EquivalentAddressGroup> computeAddressGroups();
}

