/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.router.api.rpc;

import com.tencent.polaris.api.pojo.RouteArgument;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.SourceService;
import com.tencent.polaris.api.rpc.MetadataFailoverType;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ProcessRoutersRequest
extends RequestBaseEntity {
    private SourceService sourceService;
    private RouterNamesGroup routers;
    private ServiceInstances dstInstances;
    private String method;
    private Map<String, Set<RouteArgument>> routerArgument;
    private MetadataFailoverType metadataFailoverType;

    public ServiceInfo getSourceService() {
        return this.sourceService;
    }

    public void setSourceService(ServiceInfo serviceInfo) {
        this.sourceService = new SourceService();
        this.sourceService.setService(serviceInfo.getService());
        this.sourceService.setNamespace(serviceInfo.getNamespace());
        ((Map)Optional.ofNullable(serviceInfo.getMetadata()).orElse(new HashMap())).forEach((key, value) -> this.sourceService.appendArguments(RouteArgument.fromLabel(key, value)));
        this.buildRouterArgumentsBySourceService();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public RouterNamesGroup getRouters() {
        return this.routers;
    }

    public void setRouters(RouterNamesGroup routers) {
        this.routers = routers;
    }

    public ServiceInstances getDstInstances() {
        return this.dstInstances;
    }

    public void setDstInstances(ServiceInstances dstInstances) {
        this.dstInstances = dstInstances;
    }

    public void putRouterArgument(String routerType, Set<RouteArgument> arguments) {
        if (CollectionUtils.isEmpty(arguments)) {
            return;
        }
        if (this.routerArgument == null) {
            this.routerArgument = new HashMap<String, Set<RouteArgument>>();
        }
        this.routerArgument.put(routerType, arguments);
    }

    public Set<RouteArgument> getRouterArguments(String routerType) {
        this.buildRouterArgumentsBySourceService();
        Set<RouteArgument> arguments = this.routerArgument.get(routerType);
        if (CollectionUtils.isEmpty(arguments)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(arguments);
    }

    public Map<String, Set<RouteArgument>> getRouterArguments() {
        this.buildRouterArgumentsBySourceService();
        HashMap<String, Set<RouteArgument>> routerArgument = new HashMap<String, Set<RouteArgument>>(this.routerArgument);
        return Collections.unmodifiableMap(routerArgument);
    }

    public MetadataFailoverType getMetadataFailoverType() {
        return this.metadataFailoverType;
    }

    public void setMetadataFailoverType(MetadataFailoverType metadataFailoverType) {
        this.metadataFailoverType = metadataFailoverType;
    }

    private void buildRouterArgumentsBySourceService() {
        if (CollectionUtils.isEmpty(this.routerArgument)) {
            this.routerArgument = new HashMap<String, Set<RouteArgument>>();
        }
        if (Objects.isNull(this.sourceService)) {
            return;
        }
        Set arguments = this.routerArgument.computeIfAbsent("ruleRouter", k -> new HashSet());
        arguments.addAll(this.sourceService.getArguments());
    }

    @Deprecated
    public void putRouterMetadata(String routerType, Map<String, String> metadata) {
        if (MapUtils.isEmpty(metadata)) {
            return;
        }
        if (this.routerArgument == null) {
            this.routerArgument = new HashMap<String, Set<RouteArgument>>();
        }
        HashSet arguments = new HashSet();
        metadata.forEach((key, value) -> arguments.add(RouteArgument.fromLabel(key, value)));
        this.routerArgument.put(routerType, arguments);
    }

    @Deprecated
    public void addRouterMetadata(String routerType, Map<String, String> metadata) {
        if (MapUtils.isEmpty(metadata)) {
            return;
        }
        if (this.routerArgument == null) {
            this.routerArgument = new HashMap<String, Set<RouteArgument>>();
        }
        Set arguments = this.routerArgument.computeIfAbsent(routerType, k -> new HashSet());
        metadata.forEach((key, value) -> arguments.add(RouteArgument.fromLabel(key, value)));
    }

    @Deprecated
    public Map<String, String> getRouterMetadata(String routerType) {
        this.buildRouterArgumentsBySourceService();
        Set<RouteArgument> arguments = this.routerArgument.get(routerType);
        if (CollectionUtils.isEmpty(arguments)) {
            return Collections.emptyMap();
        }
        HashMap metadata = new HashMap();
        arguments.forEach(argument -> argument.toLabel(metadata));
        return Collections.unmodifiableMap(metadata);
    }

    @Deprecated
    public Map<String, Map<String, String>> getRouterMetadata() {
        this.buildRouterArgumentsBySourceService();
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>();
        this.routerArgument.forEach((routerType, arguments) -> {
            Map entry = ret.computeIfAbsent((String)routerType, k -> new HashMap());
            arguments.forEach(argument -> argument.toLabel(entry));
        });
        return ret;
    }

    public static class RouterNamesGroup {
        private List<String> beforeRouters;
        private List<String> coreRouters;
        private List<String> afterRouters;

        public List<String> getBeforeRouters() {
            return this.beforeRouters;
        }

        public void setBeforeRouters(List<String> beforeRouters) {
            this.beforeRouters = beforeRouters;
        }

        public List<String> getCoreRouters() {
            return this.coreRouters;
        }

        public void setCoreRouters(List<String> coreRouters) {
            this.coreRouters = coreRouters;
        }

        public List<String> getAfterRouters() {
            return this.afterRouters;
        }

        public void setAfterRouters(List<String> afterRouters) {
            this.afterRouters = afterRouters;
        }
    }
}

