/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.pojo;

import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import java.util.Map;

public class ServiceInfo
implements ServiceMetadata,
Comparable<ServiceInfo> {
    private final ServiceKey serviceKey = new ServiceKey();
    private Map<String, String> metadata;
    private String revision;

    @Override
    public String getNamespace() {
        return this.serviceKey.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.serviceKey.setNamespace(namespace);
    }

    @Override
    public String getService() {
        return this.serviceKey.getService();
    }

    public void setService(String service) {
        this.serviceKey.setService(service);
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public ServiceKey getServiceKey() {
        return this.serviceKey;
    }

    public String toString() {
        return "ServiceInfo{namespace='" + this.serviceKey.getNamespace() + '\'' + ", service='" + this.serviceKey.getService() + '\'' + ", metadata=" + this.metadata + '}';
    }

    public static ServiceInfoBuilder builder() {
        return new ServiceInfoBuilder();
    }

    @Override
    public int compareTo(ServiceInfo o) {
        String key1 = this.serviceKey.getNamespace() + "##" + this.serviceKey.getService();
        String key2 = o.getNamespace() + "##" + o.getService();
        return key1.compareTo(key2);
    }

    public static final class ServiceInfoBuilder {
        private String namespace;
        private String service;
        private Map<String, String> metadata;
        private String revision;

        private ServiceInfoBuilder() {
        }

        public ServiceInfoBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ServiceInfoBuilder service(String service) {
            this.service = service;
            return this;
        }

        public ServiceInfoBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ServiceInfoBuilder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public ServiceInfo build() {
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setNamespace(this.namespace);
            serviceInfo.setService(this.service);
            serviceInfo.setMetadata(this.metadata);
            serviceInfo.setRevision(this.revision);
            return serviceInfo;
        }
    }
}

