/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class ObjectReaderMisc
implements ObjectReader {
    static final long HASH_ADDRESS = Fnv.hashCode64("address");
    static final long HASH_PORT = Fnv.hashCode64("port");
    private final Class objectClass;

    public ObjectReaderMisc(Class objectClass) {
        this.objectClass = objectClass;
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.nextIfNull()) {
            return null;
        }
        if (this.objectClass == InetSocketAddress.class) {
            InetAddress inetAddress = null;
            int port = 0;
            jsonReader.nextIfObjectStart();
            while (!jsonReader.nextIfObjectEnd()) {
                long nameHashCode = jsonReader.readFieldNameHashCode();
                if (nameHashCode == HASH_ADDRESS) {
                    inetAddress = jsonReader.read(InetAddress.class);
                    continue;
                }
                if (nameHashCode == HASH_PORT) {
                    port = jsonReader.readInt32();
                    continue;
                }
                jsonReader.skipValue();
            }
            jsonReader.nextIfComma();
            return new InetSocketAddress(inetAddress, port);
        }
        throw new JSONException(jsonReader.info("not support : " + this.objectClass.getName()));
    }
}

