/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.qos.api.PermissionLevel;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.migration.MigrationInvoker;
import org.apache.dubbo.registry.client.migration.model.MigrationStep;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.directory.AbstractDirectory;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;

@Cmd(name="getAddress", summary="Get service available address ", example={"getAddress com.example.DemoService", "getAddress group/com.example.DemoService"}, requiredPermissionLevel=PermissionLevel.PRIVATE)
public class GetAddress
implements BaseCommand {
    public final FrameworkServiceRepository serviceRepository;

    public GetAddress(FrameworkModel frameworkModel) {
        this.serviceRepository = frameworkModel.getServiceRepository();
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        if (args == null || args.length != 1) {
            return "Invalid parameters, please input like getAddress com.example.DemoService";
        }
        String serviceName = args[0];
        StringBuilder plainOutput = new StringBuilder();
        HashMap<String, Object> jsonOutput = new HashMap<String, Object>();
        for (ConsumerModel consumerModel : this.serviceRepository.allConsumerModels()) {
            if (!serviceName.equals(consumerModel.getServiceKey())) continue;
            GetAddress.appendConsumer(plainOutput, jsonOutput, consumerModel);
        }
        if (commandContext.isHttp()) {
            return JsonUtils.toJson(jsonOutput);
        }
        return plainOutput.toString();
    }

    private static void appendConsumer(StringBuilder plainOutput, Map<String, Object> jsonOutput, ConsumerModel consumerModel) {
        plainOutput.append("ConsumerModel: ").append(consumerModel.getServiceKey()).append("@").append(Integer.toHexString(System.identityHashCode(consumerModel))).append("\n\n");
        HashMap<String, Object> consumerMap = new HashMap<String, Object>();
        jsonOutput.put(consumerModel.getServiceKey() + "@" + Integer.toHexString(System.identityHashCode(consumerModel)), consumerMap);
        Object object = consumerModel.getServiceMetadata().getAttribute("currentClusterInvoker");
        if (object instanceof Map) {
            Map invokerMap = (Map)object;
            for (Map.Entry<Registry, MigrationInvoker<?>> entry : invokerMap.entrySet()) {
                GetAddress.appendInvokers(plainOutput, consumerMap, entry);
            }
        }
    }

    private static void appendInvokers(StringBuilder plainOutput, Map<String, Object> consumerMap, Map.Entry<Registry, MigrationInvoker<?>> entry) {
        URL registryUrl = entry.getKey().getUrl();
        plainOutput.append("Registry: ").append(registryUrl).append("\n");
        HashMap<String, Object> registryMap = new HashMap<String, Object>();
        consumerMap.put(registryUrl.toString(), registryMap);
        MigrationInvoker<?> migrationInvoker = entry.getValue();
        MigrationStep migrationStep = migrationInvoker.getMigrationStep();
        plainOutput.append("MigrationStep: ").append((Object)migrationStep).append("\n\n");
        registryMap.put("MigrationStep", (Object)migrationStep);
        HashMap<String, Object> invokersMap = new HashMap<String, Object>();
        registryMap.put("Invokers", invokersMap);
        URL originConsumerUrl = RpcContext.getServiceContext().getConsumerUrl();
        RpcContext.getServiceContext().setConsumerUrl(migrationInvoker.getConsumerUrl());
        GetAddress.appendInterfaceLevel(plainOutput, migrationInvoker, invokersMap);
        GetAddress.appendAppLevel(plainOutput, migrationInvoker, invokersMap);
        RpcContext.getServiceContext().setConsumerUrl(originConsumerUrl);
    }

    private static void appendAppLevel(StringBuilder plainOutput, MigrationInvoker<?> migrationInvoker, Map<String, Object> invokersMap) {
        HashMap appMap = new HashMap();
        invokersMap.put("Application-Level", appMap);
        Optional.ofNullable(migrationInvoker.getServiceDiscoveryInvoker()).ifPresent(i -> plainOutput.append("Application-Level: \n"));
        Optional.ofNullable(migrationInvoker.getServiceDiscoveryInvoker()).map(ClusterInvoker::getDirectory).map(Directory::getAllInvokers).ifPresent(invokers -> {
            LinkedList<String> invokerUrls = new LinkedList<String>();
            plainOutput.append("All Invokers: \n");
            for (Invoker invoker : invokers) {
                invokerUrls.add(invoker.getUrl().toFullString());
                plainOutput.append(invoker.getUrl().toFullString()).append("\n");
            }
            plainOutput.append("\n");
            appMap.put("All", invokerUrls);
        });
        Optional.ofNullable(migrationInvoker.getServiceDiscoveryInvoker()).map(ClusterInvoker::getDirectory).map(s -> (AbstractDirectory)s).map(AbstractDirectory::getValidInvokers).ifPresent(invokers -> {
            LinkedList<String> invokerUrls = new LinkedList<String>();
            plainOutput.append("Valid Invokers: \n");
            for (Invoker invoker : invokers) {
                invokerUrls.add(invoker.getUrl().toFullString());
                plainOutput.append(invoker.getUrl().toFullString()).append("\n");
            }
            plainOutput.append("\n");
            appMap.put("Valid", invokerUrls);
        });
        Optional.ofNullable(migrationInvoker.getServiceDiscoveryInvoker()).map(ClusterInvoker::getDirectory).map(s -> (AbstractDirectory)s).map(AbstractDirectory::getDisabledInvokers).ifPresent(invokers -> {
            LinkedList<String> invokerUrls = new LinkedList<String>();
            plainOutput.append("Disabled Invokers: \n");
            for (Invoker invoker : invokers) {
                invokerUrls.add(invoker.getUrl().toFullString());
                plainOutput.append(invoker.getUrl().toFullString()).append("\n");
            }
            plainOutput.append("\n");
            appMap.put("Disabled", invokerUrls);
        });
    }

    private static void appendInterfaceLevel(StringBuilder plainOutput, MigrationInvoker<?> migrationInvoker, Map<String, Object> invokersMap) {
        HashMap interfaceMap = new HashMap();
        invokersMap.put("Interface-Level", interfaceMap);
        Optional.ofNullable(migrationInvoker.getInvoker()).ifPresent(i -> plainOutput.append("Interface-Level: \n"));
        Optional.ofNullable(migrationInvoker.getInvoker()).map(ClusterInvoker::getDirectory).map(Directory::getAllInvokers).ifPresent(invokers -> {
            LinkedList<String> invokerUrls = new LinkedList<String>();
            plainOutput.append("All Invokers: \n");
            for (Invoker invoker : invokers) {
                invokerUrls.add(invoker.getUrl().toFullString());
                plainOutput.append(invoker.getUrl().toFullString()).append("\n");
            }
            plainOutput.append("\n");
            interfaceMap.put("All", invokerUrls);
        });
        Optional.ofNullable(migrationInvoker.getInvoker()).map(ClusterInvoker::getDirectory).map(s -> (AbstractDirectory)s).map(AbstractDirectory::getValidInvokers).ifPresent(invokers -> {
            LinkedList<String> invokerUrls = new LinkedList<String>();
            plainOutput.append("Valid Invokers: \n");
            for (Invoker invoker : invokers) {
                invokerUrls.add(invoker.getUrl().toFullString());
                plainOutput.append(invoker.getUrl().toFullString()).append("\n");
            }
            plainOutput.append("\n");
            interfaceMap.put("Valid", invokerUrls);
        });
        Optional.ofNullable(migrationInvoker.getInvoker()).map(ClusterInvoker::getDirectory).map(s -> (AbstractDirectory)s).map(AbstractDirectory::getDisabledInvokers).ifPresent(invokers -> {
            LinkedList<String> invokerUrls = new LinkedList<String>();
            plainOutput.append("Disabled Invokers: \n");
            for (Invoker invoker : invokers) {
                invokerUrls.add(invoker.getUrl().toFullString());
                plainOutput.append(invoker.getUrl().toFullString()).append("\n");
            }
            plainOutput.append("\n");
            interfaceMap.put("Disabled", invokerUrls);
        });
    }
}

