/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.prometheus;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.exporter.BasicAuthHttpConnectionFactory;
import io.prometheus.client.exporter.HttpConnectionFactory;
import io.prometheus.client.exporter.PushGateway;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metrics.report.AbstractMetricsReporter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class PrometheusMetricsReporter
extends AbstractMetricsReporter {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(PrometheusMetricsReporter.class);
    private final PrometheusMeterRegistry prometheusRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
    private ScheduledExecutorService pushJobExecutor = null;

    public PrometheusMetricsReporter(URL url, ApplicationModel applicationModel) {
        super(url, applicationModel);
    }

    @Override
    public void doInit() {
        this.addMeterRegistry((MeterRegistry)this.prometheusRegistry);
        this.schedulePushJob();
    }

    @Override
    public String getResponse() {
        return this.prometheusRegistry.scrape();
    }

    private void schedulePushJob() {
        boolean pushEnabled = this.url.getParameter("prometheus.pushgateway.enabled", false);
        if (pushEnabled) {
            String baseUrl = this.url.getParameter("prometheus.pushgateway.base.url");
            String job = this.url.getParameter("prometheus.pushgateway.job", "default_dubbo_job");
            int pushInterval = this.url.getParameter("prometheus.pushgateway.push.interval", 30);
            String username = this.url.getParameter("prometheus.pushgateway.username");
            String password = this.url.getParameter("prometheus.pushgateway.password");
            NamedThreadFactory threadFactory = new NamedThreadFactory("prometheus-push-job", true);
            this.pushJobExecutor = Executors.newScheduledThreadPool(1, threadFactory);
            PushGateway pushGateway = new PushGateway(baseUrl);
            if (!StringUtils.isBlank(username)) {
                pushGateway.setConnectionFactory((HttpConnectionFactory)new BasicAuthHttpConnectionFactory(username, password));
            }
            this.pushJobExecutor.scheduleWithFixedDelay(() -> this.push(pushGateway, job), pushInterval, pushInterval, TimeUnit.SECONDS);
        }
    }

    protected void push(PushGateway pushGateway, String job) {
        try {
            this.resetIfSamplesChanged();
            pushGateway.pushAdd(this.prometheusRegistry.getPrometheusRegistry(), job);
        }
        catch (IOException e) {
            this.logger.error("0-13", "", "", "Error occurred when pushing metrics to prometheus: ", e);
        }
    }

    @Override
    public void doDestroy() {
        if (this.pushJobExecutor != null) {
            this.pushJobExecutor.shutdownNow();
        }
    }

    @Deprecated
    public ScheduledExecutorService getPushJobExecutor() {
        return this.pushJobExecutor;
    }

    @Deprecated
    public PrometheusMeterRegistry getPrometheusRegistry() {
        return this.prometheusRegistry;
    }
}

