/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model.sample;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToDoubleFunction;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.sample.MetricSample;

public class GaugeMetricSample<T>
extends MetricSample {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(GaugeMetricSample.class);
    private final AtomicBoolean warned = new AtomicBoolean(false);
    private final T value;
    private final ToDoubleFunction<T> apply;

    public GaugeMetricSample(MetricsKey metricsKey, Map<String, String> tags, MetricsCategory category, T value, ToDoubleFunction<T> apply) {
        this(metricsKey.getName(), metricsKey.getDescription(), tags, category, null, value, apply);
    }

    public GaugeMetricSample(MetricsKeyWrapper metricsKeyWrapper, Map<String, String> tags, MetricsCategory category, T value, ToDoubleFunction<T> apply) {
        this(metricsKeyWrapper.targetKey(), metricsKeyWrapper.targetDesc(), tags, category, null, value, apply);
    }

    public GaugeMetricSample(String name, String description, Map<String, String> tags, MetricsCategory category, T value, ToDoubleFunction<T> apply) {
        this(name, description, tags, category, null, value, apply);
    }

    public GaugeMetricSample(String name, String description, Map<String, String> tags, MetricsCategory category, String baseUnit, T value, ToDoubleFunction<T> apply) {
        super(name, description, tags, MetricSample.Type.GAUGE, category, baseUnit);
        this.value = Objects.requireNonNull(value, "The GaugeMetricSample value cannot be null");
        Objects.requireNonNull(apply, "The GaugeMetricSample apply cannot be null");
        this.apply = e -> {
            try {
                return apply.applyAsDouble(e);
            }
            catch (Throwable t) {
                if (this.warned.compareAndSet(false, true)) {
                    logger.error("0-13", "", "", "Unexpected error occurred when applying the GaugeMetricSample", t);
                }
                return 0.0;
            }
        };
    }

    public T getValue() {
        return this.value;
    }

    public ToDoubleFunction<T> getApply() {
        return this.apply;
    }

    public long applyAsLong() {
        return (long)this.getApply().applyAsDouble(this.getValue());
    }

    public double applyAsDouble() {
        return this.getApply().applyAsDouble(this.getValue());
    }
}

