/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.concurrent.TimeUnit;

public final class TimeUtils {
    private static volatile long currentTimeMillis;
    private static volatile boolean isTickerAlive;
    private static volatile boolean isFallback;

    private TimeUtils() {
    }

    public static long currentTimeMillis() {
        if (isFallback) {
            return System.currentTimeMillis();
        }
        if (!isTickerAlive) {
            try {
                TimeUtils.startTicker();
            }
            catch (Exception e) {
                isFallback = true;
            }
        }
        return currentTimeMillis;
    }

    private static synchronized void startTicker() {
        if (!isTickerAlive) {
            currentTimeMillis = System.currentTimeMillis();
            Thread ticker = new Thread(() -> {
                while (isTickerAlive) {
                    currentTimeMillis = System.currentTimeMillis();
                    try {
                        TimeUnit.MILLISECONDS.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        isTickerAlive = false;
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception exception) {}
                }
            });
            ticker.setDaemon(true);
            ticker.setName("time-millis-ticker-thread");
            ticker.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                isFallback = true;
                ticker.interrupt();
            }));
            isTickerAlive = true;
        }
    }

    static {
        isTickerAlive = false;
        isFallback = false;
    }
}

