/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;

public class ProtobufUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProtobufUtils.class);
    private static Class<?> protobufClss;

    private ProtobufUtils() {
    }

    public static boolean isProtobufClass(Class<?> pojoClazz) {
        if (protobufClss != null) {
            return protobufClss.isAssignableFrom(pojoClazz);
        }
        return false;
    }

    static {
        try {
            protobufClss = ClassUtils.forName("com.google.protobuf.Message", ProtobufUtils.class.getClassLoader());
        }
        catch (Throwable t) {
            logger.info("protobuf's dependency is absent");
        }
    }
}

