/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.convert;

import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.lang.Prioritized;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.TypeUtils;

@SPI(scope=ExtensionScope.FRAMEWORK)
@FunctionalInterface
public interface Converter<S, T>
extends Prioritized {
    default public boolean accept(Class<?> sourceType, Class<?> targetType) {
        return ClassUtils.isAssignableFrom(sourceType, this.getSourceType()) && ClassUtils.isAssignableFrom(targetType, this.getTargetType());
    }

    public T convert(S var1);

    default public Class<S> getSourceType() {
        return TypeUtils.findActualTypeArgument(this.getClass(), Converter.class, 0);
    }

    default public Class<T> getTargetType() {
        return TypeUtils.findActualTypeArgument(this.getClass(), Converter.class, 1);
    }
}

