/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin;

public class ListTopicsOptions {
    public static final ListTopicsOptions EMPTY = ListTopicsOptions.builder().build();
    private final String bundle;
    private final boolean includeSystemTopic;

    ListTopicsOptions(String bundle, boolean includeSystemTopic) {
        this.bundle = bundle;
        this.includeSystemTopic = includeSystemTopic;
    }

    public static ListTopicsOptionsBuilder builder() {
        return new ListTopicsOptionsBuilder();
    }

    public String getBundle() {
        return this.bundle;
    }

    public boolean isIncludeSystemTopic() {
        return this.includeSystemTopic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListTopicsOptions)) {
            return false;
        }
        ListTopicsOptions other = (ListTopicsOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIncludeSystemTopic() != other.isIncludeSystemTopic()) {
            return false;
        }
        String this$bundle = this.getBundle();
        String other$bundle = other.getBundle();
        return !(this$bundle == null ? other$bundle != null : !this$bundle.equals(other$bundle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListTopicsOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeSystemTopic() ? 79 : 97);
        String $bundle = this.getBundle();
        result = result * 59 + ($bundle == null ? 43 : $bundle.hashCode());
        return result;
    }

    public String toString() {
        return "ListTopicsOptions(bundle=" + this.getBundle() + ", includeSystemTopic=" + this.isIncludeSystemTopic() + ")";
    }

    public static class ListTopicsOptionsBuilder {
        private String bundle;
        private boolean includeSystemTopic;

        ListTopicsOptionsBuilder() {
        }

        public ListTopicsOptionsBuilder bundle(String bundle) {
            this.bundle = bundle;
            return this;
        }

        public ListTopicsOptionsBuilder includeSystemTopic(boolean includeSystemTopic) {
            this.includeSystemTopic = includeSystemTopic;
            return this;
        }

        public ListTopicsOptions build() {
            return new ListTopicsOptions(this.bundle, this.includeSystemTopic);
        }

        public String toString() {
            return "ListTopicsOptions.ListTopicsOptionsBuilder(bundle=" + this.bundle + ", includeSystemTopic=" + this.includeSystemTopic + ")";
        }
    }
}

