/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.controller;

import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.node.OccupyTimeoutProperty;
import com.alibaba.csp.sentinel.slots.block.flow.PriorityWaitException;
import com.alibaba.csp.sentinel.slots.block.flow.TrafficShapingController;
import com.alibaba.csp.sentinel.util.TimeUtil;

public class DefaultController
implements TrafficShapingController {
    private static final int DEFAULT_AVG_USED_TOKENS = 0;
    private double count;
    private int grade;

    public DefaultController(double count, int grade) {
        this.count = count;
        this.grade = grade;
    }

    @Override
    public boolean canPass(Node node, int acquireCount) {
        return this.canPass(node, acquireCount, false);
    }

    @Override
    public boolean canPass(Node node, int acquireCount, boolean prioritized) {
        int curCount = this.avgUsedTokens(node);
        if ((double)(curCount + acquireCount) > this.count) {
            long currentTime;
            long waitInMs;
            if (prioritized && this.grade == 1 && (waitInMs = node.tryOccupyNext(currentTime = TimeUtil.currentTimeMillis(), acquireCount, this.count)) < (long)OccupyTimeoutProperty.getOccupyTimeout()) {
                node.addWaitingRequest(currentTime + waitInMs, acquireCount);
                node.addOccupiedPass(acquireCount);
                this.sleep(waitInMs);
                throw new PriorityWaitException(waitInMs);
            }
            return false;
        }
        return true;
    }

    private int avgUsedTokens(Node node) {
        if (node == null) {
            return 0;
        }
        return this.grade == 0 ? node.curThreadNum() : (int)node.passQps();
    }

    private void sleep(long timeMillis) {
        try {
            Thread.sleep(timeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

