/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseInstantValue;
import com.clickhouse.client.data.ClickHouseObjectValue;
import com.clickhouse.client.data.ClickHouseOffsetDateTimeValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;

public class ClickHouseDateTimeValue
extends ClickHouseObjectValue<LocalDateTime> {
    public static final LocalDateTime DEFAULT = ClickHouseInstantValue.DEFAULT.atOffset(ZoneOffset.UTC).toLocalDateTime();
    static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final int scale;
    private final TimeZone tz;
    private final LocalDateTime defaultValue;

    public static ClickHouseDateTimeValue ofNull(int scale, TimeZone tz) {
        return ClickHouseDateTimeValue.ofNull(null, scale, tz);
    }

    public static ClickHouseDateTimeValue ofNull(ClickHouseValue ref, int scale, TimeZone tz) {
        return ref instanceof ClickHouseDateTimeValue ? (ClickHouseDateTimeValue)((ClickHouseDateTimeValue)ref).set(null) : new ClickHouseDateTimeValue(null, scale, tz);
    }

    public static ClickHouseDateTimeValue of(LocalDateTime value, int scale, TimeZone tz) {
        return ClickHouseDateTimeValue.of(null, value, scale, tz);
    }

    public static ClickHouseDateTimeValue of(String value, int scale, TimeZone tz) {
        return ClickHouseDateTimeValue.of(null, value, scale, tz);
    }

    public static ClickHouseDateTimeValue of(ClickHouseValue ref, LocalDateTime value, int scale, TimeZone tz) {
        return ref instanceof ClickHouseDateTimeValue ? (ClickHouseDateTimeValue)((ClickHouseDateTimeValue)ref).set(value) : new ClickHouseDateTimeValue(value, scale, tz);
    }

    public static ClickHouseDateTimeValue of(ClickHouseValue ref, String value, int scale, TimeZone tz) {
        LocalDateTime dateTime = value == null || value.isEmpty() ? null : LocalDateTime.parse(value, ClickHouseValues.DATETIME_FORMATTER);
        return ClickHouseDateTimeValue.of(ref, dateTime, scale, tz);
    }

    protected ClickHouseDateTimeValue(LocalDateTime value, int scale, TimeZone tz) {
        super(value);
        this.scale = ClickHouseChecker.between(scale, "scale", 0, 9);
        this.tz = tz != null ? tz : ClickHouseValues.UTC_TIMEZONE;
        this.defaultValue = this.tz.equals(ClickHouseValues.UTC_TIMEZONE) ? DEFAULT : ClickHouseOffsetDateTimeValue.DEFAULT.toZonedDateTime().withZoneSameInstant(this.tz.toZoneId()).toLocalDateTime();
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public ClickHouseDateTimeValue copy(boolean deep) {
        return new ClickHouseDateTimeValue((LocalDateTime)this.getValue(), this.scale, this.tz);
    }

    @Override
    public byte asByte() {
        return this.isNullOrEmpty() ? (byte)0 : (byte)((LocalDateTime)this.getValue()).atZone(this.tz.toZoneId()).toEpochSecond();
    }

    @Override
    public short asShort() {
        return this.isNullOrEmpty() ? (short)0 : (short)((LocalDateTime)this.getValue()).atZone(this.tz.toZoneId()).toEpochSecond();
    }

    @Override
    public int asInteger() {
        return this.isNullOrEmpty() ? 0 : (int)((LocalDateTime)this.getValue()).atZone(this.tz.toZoneId()).toEpochSecond();
    }

    @Override
    public long asLong() {
        return this.isNullOrEmpty() ? 0L : ((LocalDateTime)this.getValue()).atZone(this.tz.toZoneId()).toEpochSecond();
    }

    @Override
    public float asFloat() {
        return this.isNullOrEmpty() ? 0.0f : (float)((LocalDateTime)this.getValue()).atZone(this.tz.toZoneId()).toEpochSecond() + (float)((LocalDateTime)this.getValue()).getNano() / ClickHouseValues.NANOS.floatValue();
    }

    @Override
    public double asDouble() {
        return this.isNullOrEmpty() ? 0.0 : (double)((LocalDateTime)this.getValue()).atZone(this.tz.toZoneId()).toEpochSecond() + (double)((LocalDateTime)this.getValue()).getNano() / ClickHouseValues.NANOS.doubleValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNullOrEmpty() ? null : BigInteger.valueOf(((LocalDateTime)this.getValue()).atZone(this.tz.toZoneId()).toEpochSecond());
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        LocalDateTime value = (LocalDateTime)this.getValue();
        BigDecimal v = null;
        if (value != null) {
            int nanoSeconds = value.getNano();
            v = new BigDecimal(BigInteger.valueOf(value.atZone(this.tz.toZoneId()).toEpochSecond()), scale);
            if (scale != 0 && nanoSeconds != 0) {
                v = v.add(BigDecimal.valueOf(nanoSeconds).divide(ClickHouseValues.NANOS).setScale(scale, ClickHouseValues.ROUNDING_MODE));
            }
        }
        return v;
    }

    @Override
    public LocalDate asDate() {
        return this.isNullOrEmpty() ? null : this.asDateTime(0).toLocalDate();
    }

    @Override
    public LocalDateTime asDateTime(int scale) {
        return (LocalDateTime)this.getValue();
    }

    @Override
    public Instant asInstant(int scale) {
        return this.isNullOrEmpty() ? null : ((LocalDateTime)this.getValue()).atZone(this.tz.toZoneId()).toInstant();
    }

    @Override
    public OffsetDateTime asOffsetDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return ((LocalDateTime)this.getValue()).atZone(this.tz.toZoneId()).toOffsetDateTime();
    }

    @Override
    public ZonedDateTime asZonedDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return ((LocalDateTime)this.getValue()).atZone(this.tz.toZoneId());
    }

    @Override
    public Object asObject() {
        return this.getValue();
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        String str = ((LocalDateTime)this.getValue()).format(this.scale > 0 ? ClickHouseValues.DATETIME_FORMATTER : dateTimeFormatter);
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseDateTimeValue resetToDefault() {
        this.set(this.defaultValue);
        return this;
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        return '\'' + ((LocalDateTime)this.getValue()).format(this.scale > 0 ? ClickHouseValues.DATETIME_FORMATTER : dateTimeFormatter) + '\'';
    }

    @Override
    public ClickHouseDateTimeValue update(byte value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseDateTimeValue update(short value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseDateTimeValue update(int value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseDateTimeValue update(long value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseDateTimeValue update(float value) {
        return this.update(BigDecimal.valueOf(value));
    }

    @Override
    public ClickHouseDateTimeValue update(double value) {
        return this.update(BigDecimal.valueOf(value));
    }

    @Override
    public ClickHouseDateTimeValue update(BigInteger value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (this.scale == 0) {
            this.set(ClickHouseValues.convertToDateTime(new BigDecimal(value, 0)));
        } else {
            this.set(ClickHouseValues.convertToDateTime(new BigDecimal(value, this.scale)));
        }
        return this;
    }

    @Override
    public ClickHouseDateTimeValue update(BigDecimal value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            if (value.scale() != this.scale) {
                value = value.setScale(this.scale, ClickHouseValues.ROUNDING_MODE);
            }
            this.set(ClickHouseValues.convertToDateTime(value));
        }
        return this;
    }

    @Override
    public ClickHouseDateTimeValue update(Enum<?> value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(BigInteger.valueOf(value.ordinal()));
        }
        return this;
    }

    @Override
    public ClickHouseDateTimeValue update(LocalDate value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDateTime.of(value, LocalTime.MIN));
        }
        return this;
    }

    @Override
    public ClickHouseDateTimeValue update(LocalTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDateTime.of(LocalDate.now(), value));
        }
        return this;
    }

    @Override
    public ClickHouseDateTimeValue update(LocalDateTime value) {
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseDateTimeValue update(Instant value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDateTime.ofInstant(value, this.tz.toZoneId()));
        }
        return this;
    }

    @Override
    public ClickHouseValue update(OffsetDateTime value) {
        return this.update(value != null ? value.atZoneSameInstant(this.tz.toZoneId()).toLocalDateTime() : null);
    }

    @Override
    public ClickHouseValue update(ZonedDateTime value) {
        return this.update(value != null ? LocalDateTime.ofInstant(value.toInstant(), this.tz.toZoneId()) : null);
    }

    @Override
    public ClickHouseDateTimeValue update(String value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDateTime.parse(value, ClickHouseValues.DATETIME_FORMATTER));
        }
        return this;
    }

    @Override
    public ClickHouseDateTimeValue update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.asDateTime(this.scale));
        }
        return this;
    }

    @Override
    public ClickHouseDateTimeValue update(Object value) {
        if (value instanceof LocalDateTime) {
            this.set((LocalDateTime)value);
        } else if (value instanceof String) {
            this.update((String)value);
        } else {
            super.update(value);
        }
        return this;
    }
}

