/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class IcuTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant,
TokenFilterDefinitionVariant {
    private final String ruleFiles;
    public static final JsonpDeserializer<IcuTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuTokenizer::setupIcuTokenizerDeserializer);

    private IcuTokenizer(Builder builder) {
        super(builder);
        this.ruleFiles = ApiTypeHelper.requireNonNull(builder.ruleFiles, this, "ruleFiles");
    }

    public static IcuTokenizer of(Function<Builder, ObjectBuilder<IcuTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.IcuTokenizer;
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuTokenizer;
    }

    public final String ruleFiles() {
        return this.ruleFiles;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_tokenizer");
        super.serializeInternal(generator, mapper);
        generator.writeKey("rule_files");
        generator.write(this.ruleFiles);
    }

    protected static void setupIcuTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::ruleFiles, JsonpDeserializer.stringDeserializer(), "rule_files");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IcuTokenizer> {
        private String ruleFiles;

        public final Builder ruleFiles(String value) {
            this.ruleFiles = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IcuTokenizer build() {
            this._checkSingleUse();
            return new IcuTokenizer(this);
        }
    }
}

