/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.TermsBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class StringTermsBucket
extends TermsBucketBase {
    private final FieldValue key;
    public static final JsonpDeserializer<StringTermsBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StringTermsBucket::setupStringTermsBucketDeserializer);

    private StringTermsBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
    }

    public static StringTermsBucket of(Function<Builder, ObjectBuilder<StringTermsBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final FieldValue key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("key");
        this.key.serialize(generator, mapper);
    }

    protected static void setupStringTermsBucketDeserializer(ObjectDeserializer<Builder> op) {
        TermsBucketBase.setupTermsBucketBaseDeserializer(op);
        op.add(Builder::key, FieldValue._DESERIALIZER, "key");
    }

    public static class Builder
    extends TermsBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StringTermsBucket> {
        private FieldValue key;

        public final Builder key(FieldValue value) {
            this.key = value;
            return this;
        }

        public final Builder key(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.key(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder key(String value) {
            this.key = FieldValue.of(value);
            return this;
        }

        public final Builder key(long value) {
            this.key = FieldValue.of(value);
            return this;
        }

        public final Builder key(double value) {
            this.key = FieldValue.of(value);
            return this;
        }

        public final Builder key(boolean value) {
            this.key = FieldValue.of(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StringTermsBucket build() {
            this._checkSingleUse();
            return new StringTermsBucket(this);
        }
    }
}

