/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.stat;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ProxyStatBody {
    private AtomicInteger count = new AtomicInteger();
    private AtomicInteger execCount = new AtomicInteger();
    private AtomicInteger timeoutCount = new AtomicInteger();
    private AtomicLong totalRspTime = new AtomicLong();
    private AtomicInteger maxRspTime = new AtomicInteger();
    private AtomicInteger minRspTime = new AtomicInteger();
    public ConcurrentHashMap<Integer, AtomicInteger> intervalCount = new ConcurrentHashMap();
    ReentrantReadWriteLock intervListlock = new ReentrantReadWriteLock();
    CopyOnWriteArrayList<Integer> timeStatInterval = new CopyOnWriteArrayList();

    public ProxyStatBody(List<Integer> interval) {
        this.setTimeStatInterval(interval);
    }

    public void setTimeStatInterval(List<Integer> interval) {
        this.timeStatInterval.clear();
        this.timeStatInterval.addAll(interval);
        for (Integer i : this.timeStatInterval) {
            if (this.intervalCount.containsKey(i)) continue;
            this.intervalCount.put(i, new AtomicInteger());
        }
    }

    public void onCallFinished(long costTime, int callStatus) {
        if (callStatus == 0) {
            this.count.incrementAndGet();
            this.totalRspTime.addAndGet(costTime);
            if ((long)this.maxRspTime.get() < costTime) {
                this.maxRspTime.set((int)costTime);
            } else if (costTime > 0L && costTime < (long)this.minRspTime.get()) {
                this.minRspTime.set((int)costTime);
            }
        } else if (callStatus == 1) {
            this.execCount.incrementAndGet();
        } else if (callStatus == 2) {
            this.timeoutCount.incrementAndGet();
        }
        for (int i = 0; i < this.timeStatInterval.size(); ++i) {
            if (costTime > (long)this.timeStatInterval.get(i).intValue()) continue;
            this.intervalCount.get(this.timeStatInterval.get(i)).incrementAndGet();
            break;
        }
    }

    public Object clone() {
        Object o;
        block2: {
            o = null;
            try {
                o = super.clone();
            }
            catch (CloneNotSupportedException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return o;
    }

    public void clear() {
        this.count.set(0);
        this.execCount.set(0);
        this.timeoutCount.set(0);
        for (Map.Entry<Integer, AtomicInteger> entry : this.intervalCount.entrySet()) {
            entry.getValue().set(0);
        }
        this.totalRspTime.set(0L);
        this.maxRspTime.set(0);
        this.minRspTime.set(0);
    }

    public int getCount() {
        return this.count.get();
    }

    public int getExecCount() {
        return this.execCount.get();
    }

    public int getTimeoutCount() {
        return this.timeoutCount.get();
    }

    public long getTotalRspTime() {
        return this.totalRspTime.get();
    }

    public int getMaxRspTime() {
        return this.maxRspTime.get();
    }

    public int getMinRspTime() {
        return this.minRspTime.get();
    }
}

