/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.springframework.expression.Expression;
import org.springframework.integration.JavaUtils;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.dsl.ConsumerEndpointSpec;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.dsl.MessageProcessorSpec;
import org.springframework.integration.handler.BeanNameMessageProcessor;
import org.springframework.integration.handler.LambdaMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.integration.splitter.DefaultMessageSplitter;
import org.springframework.integration.splitter.ExpressionEvaluatingSplitter;
import org.springframework.integration.splitter.MethodInvokingSplitter;
import org.springframework.integration.util.ClassUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import reactor.util.function.Tuple2;

public class SplitterSpec
extends ConsumerEndpointSpec<SplitterSpec, AbstractMessageSplitter> {
    private final AtomicBoolean splitterSet = new AtomicBoolean();
    private Expression expression;
    private Object ref;
    private String refName;
    @Nullable
    private String method;
    private Function<?, ?> function;
    @Nullable
    private Class<?> expectedType;
    @Nullable
    private String delimiters;
    @Nullable
    private String discardChannelName;
    @Nullable
    private MessageChannel discardChannel;
    @Nullable
    private Boolean applySequence;

    protected SplitterSpec() {
        super(null);
    }

    public SplitterSpec delimiters(String delimiters) {
        this.delimiters = delimiters;
        return this;
    }

    public SplitterSpec expression(String expression) {
        return this.expression(PARSER.parseExpression(expression));
    }

    public SplitterSpec expression(Expression expression) {
        this.assertSplitterSet();
        this.expression = expression;
        return this;
    }

    public SplitterSpec ref(Object ref) {
        this.assertSplitterSet();
        this.ref = ref;
        return this;
    }

    public SplitterSpec refName(String refName) {
        this.assertSplitterSet();
        this.refName = refName;
        return this;
    }

    public SplitterSpec method(@Nullable String method) {
        this.method = method;
        return this;
    }

    public <P> SplitterSpec function(Function<P, ?> function2) {
        this.assertSplitterSet();
        this.function = function2;
        return this;
    }

    public SplitterSpec expectedType(@Nullable Class<?> expectedType) {
        this.expectedType = expectedType;
        return this;
    }

    public SplitterSpec applySequence(boolean applySequence) {
        this.applySequence = applySequence;
        return this;
    }

    public SplitterSpec discardChannel(MessageChannel discardChannel) {
        this.discardChannel = discardChannel;
        return this;
    }

    public SplitterSpec discardFlow(IntegrationFlow discardFlow) {
        return this.discardChannel(this.obtainInputChannelFromFlow(discardFlow));
    }

    public SplitterSpec discardChannel(String discardChannelName) {
        this.discardChannelName = discardChannelName;
        return this;
    }

    private void assertSplitterSet() {
        Assert.isTrue((boolean)this.splitterSet.compareAndSet(false, true), this::assertMessage);
    }

    private String assertMessage() {
        String currentSplitterValue = null;
        if (this.expression != null) {
            currentSplitterValue = "'expression'=" + this.expression;
        } else if (this.ref != null) {
            currentSplitterValue = "'ref'=" + this.ref;
        } else if (this.refName != null) {
            currentSplitterValue = "'refName'=" + this.refName;
        } else if (this.function != null) {
            currentSplitterValue = "'function'=" + this.function;
        }
        return "Only one of the 'expression', 'ref', 'refName', 'function' can be set. Current one is " + currentSplitterValue;
    }

    @Override
    public Tuple2<ConsumerEndpointFactoryBean, AbstractMessageSplitter> doGet() {
        AbstractMessageSplitter splitter = new DefaultMessageSplitter();
        if (this.expression != null) {
            splitter = new ExpressionEvaluatingSplitter(this.expression);
        } else if (this.ref != null) {
            if (this.method != null) {
                splitter = new MethodInvokingSplitter(this.ref, this.method);
            } else {
                Object object = this.ref;
                if (object instanceof MessageProcessorSpec) {
                    MessageProcessorSpec messageProcessorSpec = (MessageProcessorSpec)object;
                    targetProcessor = (MessageProcessor)messageProcessorSpec.getObject();
                    this.componentsToRegister.put(targetProcessor, null);
                    splitter = new MethodInvokingSplitter(targetProcessor);
                } else {
                    targetProcessor = this.ref;
                    if (targetProcessor instanceof MessageHandlerSpec) {
                        MessageHandlerSpec messageHandlerSpec = (MessageHandlerSpec)targetProcessor;
                        MessageHandler messageHandler = (MessageHandler)messageHandlerSpec.getObject();
                        Assert.isInstanceOf(AbstractMessageSplitter.class, (Object)messageHandler, (String)"Only the 'MessageHandlerSpec' producing an `AbstractMessageSplitter` can be used as a `ref`. All others should be used in a `.handle()`.");
                        splitter = (AbstractMessageSplitter)messageHandler;
                    } else {
                        object = this.ref;
                        if (object instanceof AbstractMessageSplitter) {
                            AbstractMessageSplitter messageSplitter = (AbstractMessageSplitter)object;
                            splitter = messageSplitter;
                        } else {
                            splitter = new MethodInvokingSplitter(this.ref);
                        }
                    }
                }
            }
        } else if (this.refName != null) {
            splitter = new MethodInvokingSplitter((Object)new BeanNameMessageProcessor(this.refName, this.method));
        } else if (this.function != null) {
            splitter = this.wrapFunctionToSplitter();
        }
        if (this.delimiters != null) {
            if (splitter instanceof DefaultMessageSplitter) {
                AbstractMessageSplitter defaultMessageSplitter = splitter;
                ((DefaultMessageSplitter)defaultMessageSplitter).setDelimiters(this.delimiters);
            } else {
                this.logger.warn((Object)"'delimiters' can be applied only for the DefaultMessageSplitter");
            }
        }
        JavaUtils.INSTANCE.acceptIfNotNull(this.discardChannel, splitter::setDiscardChannel).acceptIfHasText(this.discardChannelName, splitter::setDiscardChannelName).acceptIfNotNull(this.applySequence, splitter::setApplySequence);
        this.handler = splitter;
        return super.doGet();
    }

    private MethodInvokingSplitter wrapFunctionToSplitter() {
        return ClassUtils.isLambda(this.function) ? new MethodInvokingSplitter((Object)new LambdaMessageProcessor(this.function, this.expectedType)) : new MethodInvokingSplitter(this.function, ClassUtils.FUNCTION_APPLY_METHOD);
    }
}

