/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel.interceptor;

import io.micrometer.common.lang.Nullable;
import java.util.LinkedList;
import java.util.Queue;
import org.springframework.integration.support.MessageDecorator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.ExecutorChannelInterceptor;

public abstract class ThreadStatePropagationChannelInterceptor<S>
implements ExecutorChannelInterceptor {
    public final Message<?> preSend(Message<?> message, MessageChannel channel) {
        S threadContext = this.obtainPropagatingContext(message, channel);
        if (threadContext != null) {
            if (message instanceof MessageWithThreadState) {
                MessageWithThreadState messageWithThreadState = (MessageWithThreadState)message;
                messageWithThreadState.stateQueue.add(threadContext);
            } else {
                return new MessageWithThreadState(message, threadContext);
            }
        }
        return message;
    }

    public final Message<?> postReceive(Message<?> message, MessageChannel channel) {
        if (message instanceof MessageWithThreadState) {
            Message<Object> messageWithThreadState = (Message<Object>)message;
            Object threadContext = messageWithThreadState.stateQueue.poll();
            Message<Object> messageToHandle = messageWithThreadState;
            if (messageWithThreadState.stateQueue.isEmpty()) {
                messageToHandle = messageWithThreadState.message;
            }
            this.populatePropagatedContext(threadContext, messageToHandle, channel);
            return messageToHandle;
        }
        return message;
    }

    public final Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        return this.postReceive(message, channel);
    }

    @Nullable
    protected abstract S obtainPropagatingContext(Message<?> var1, MessageChannel var2);

    protected abstract void populatePropagatedContext(@Nullable S var1, Message<?> var2, MessageChannel var3);

    private static final class MessageWithThreadState
    implements Message<Object>,
    MessageDecorator {
        private final Message<Object> message;
        private final Queue<Object> stateQueue;

        MessageWithThreadState(Message<?> message, Object state) {
            this(message, new LinkedList<Object>());
            this.stateQueue.add(state);
        }

        private MessageWithThreadState(Message<?> message, Queue<Object> stateQueue) {
            this.message = message;
            this.stateQueue = new LinkedList<Object>(stateQueue);
        }

        public Object getPayload() {
            return this.message.getPayload();
        }

        public MessageHeaders getHeaders() {
            return this.message.getHeaders();
        }

        @Override
        public Message<?> decorateMessage(Message<?> message) {
            return new MessageWithThreadState(message, this.stateQueue);
        }

        public String toString() {
            return "MessageWithThreadState{message=" + this.message + ", state=" + this.stateQueue + "}";
        }
    }
}

