/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.configfilefilter.service;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.plugins.configfilefilter.util.RSAUtil;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class RSAService {
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    public RSAService() {
        KeyPair keyPair = RSAUtil.generateRsaKeyPair();
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
    }

    public byte[] decrypt(String context) {
        return RSAUtil.decrypt(Base64.getDecoder().decode(context), this.privateKey);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getPKCS1PublicKey() {
        SubjectPublicKeyInfo spkInfo = SubjectPublicKeyInfo.getInstance(this.publicKey.getEncoded());
        try {
            ASN1Primitive primitive = spkInfo.parsePublicKey();
            byte[] publicKeyPKCS1 = primitive.getEncoded();
            return Base64.getEncoder().encodeToString(publicKeyPKCS1);
        }
        catch (IOException e) {
            throw new PolarisException(ErrorCode.RSA_KEY_GENERATE_ERROR, e.getMessage());
        }
    }
}

