/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.disruptor.consumer.QueueConsumer;
import org.apache.shenyu.disruptor.consumer.QueueConsumerFactory;
import org.apache.shenyu.disruptor.event.DisruptorEventFactory;
import org.apache.shenyu.disruptor.event.OrderlyDisruptorEventFactory;
import org.apache.shenyu.disruptor.provider.DisruptorProvider;
import org.apache.shenyu.disruptor.thread.DisruptorThreadFactory;
import org.apache.shenyu.disruptor.thread.OrderlyExecutor;

public class DisruptorProviderManage<T> {
    public static final Integer DEFAULT_SIZE = 16384;
    private static final Integer DEFAULT_CONSUMER_SIZE = Runtime.getRuntime().availableProcessors() << 1;
    private final Integer size;
    private final Integer consumerSize;
    private final QueueConsumerFactory<T> consumerFactory;
    private DisruptorProvider<T> provider;

    public DisruptorProviderManage(QueueConsumerFactory<T> consumerFactory, Integer ringBufferSize) {
        this(consumerFactory, DEFAULT_CONSUMER_SIZE, ringBufferSize);
    }

    public DisruptorProviderManage(QueueConsumerFactory<T> consumerFactory) {
        this(consumerFactory, DEFAULT_CONSUMER_SIZE, DEFAULT_SIZE);
    }

    public DisruptorProviderManage(QueueConsumerFactory<T> consumerFactory, int consumerSize, int ringBufferSize) {
        this.consumerFactory = consumerFactory;
        this.size = ringBufferSize;
        this.consumerSize = consumerSize;
    }

    public void startup() {
        this.startup(false);
    }

    public void startup(boolean isOrderly) {
        Object eventFactory;
        OrderlyExecutor executor = new OrderlyExecutor(isOrderly, this.consumerSize, this.consumerSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), DisruptorThreadFactory.create("shenyu_disruptor_consumer_", false), new ThreadPoolExecutor.AbortPolicy());
        int newConsumerSize = this.consumerSize;
        if (isOrderly) {
            newConsumerSize = 1;
            eventFactory = new OrderlyDisruptorEventFactory();
        } else {
            eventFactory = new DisruptorEventFactory();
        }
        Disruptor disruptor = new Disruptor(eventFactory, this.size.intValue(), DisruptorThreadFactory.create("shenyu_disruptor_provider_" + this.consumerFactory.fixName(), false), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        WorkHandler[] consumers = new QueueConsumer[newConsumerSize];
        for (int i = 0; i < newConsumerSize; ++i) {
            consumers[i] = new QueueConsumer<T>(executor, this.consumerFactory);
        }
        disruptor.handleEventsWithWorkerPool(consumers);
        disruptor.setDefaultExceptionHandler((ExceptionHandler)new IgnoreExceptionHandler());
        disruptor.start();
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        this.provider = new DisruptorProvider(ringBuffer, disruptor, isOrderly);
    }

    public DisruptorProvider<T> getProvider() {
        return this.provider;
    }
}

