/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.InstanceRegionChecker;
import com.netflix.discovery.provider.Serializer;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.util.StringCache;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

@Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
@XStreamAlias(value="application")
@JsonRootName(value="application")
public class Application {
    private static Random shuffleRandom = new Random();
    private String name;
    @XStreamOmitField
    private volatile boolean isDirty = false;
    @XStreamImplicit
    private final Set<InstanceInfo> instances = new LinkedHashSet<InstanceInfo>();
    private final AtomicReference<List<InstanceInfo>> shuffledInstances;
    private final Map<String, InstanceInfo> instancesMap = new ConcurrentHashMap<String, InstanceInfo>();

    public String toString() {
        return "Application [name=" + this.name + ", isDirty=" + this.isDirty + ", instances=" + this.instances + ", shuffledInstances=" + this.shuffledInstances + ", instancesMap=" + this.instancesMap + "]";
    }

    public Application() {
        this.shuffledInstances = new AtomicReference();
    }

    public Application(String name) {
        this();
        this.name = StringCache.intern(name);
    }

    @JsonCreator
    public Application(@JsonProperty(value="name") String name, @JsonProperty(value="instance") List<InstanceInfo> instances) {
        this(name);
        for (InstanceInfo instanceInfo : instances) {
            this.addInstance(instanceInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstance(InstanceInfo i) {
        this.instancesMap.put(i.getId(), i);
        Set<InstanceInfo> set = this.instances;
        synchronized (set) {
            this.instances.remove(i);
            this.instances.add(i);
            this.isDirty = true;
        }
    }

    public void removeInstance(InstanceInfo i) {
        this.removeInstance(i, true);
    }

    @JsonProperty(value="instance")
    public List<InstanceInfo> getInstances() {
        return Optional.ofNullable(this.shuffledInstances.get()).orElseGet(this::getInstancesAsIsFromEureka);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public List<InstanceInfo> getInstancesAsIsFromEureka() {
        Set<InstanceInfo> set = this.instances;
        synchronized (set) {
            return new ArrayList<InstanceInfo>(this.instances);
        }
    }

    public InstanceInfo getByInstanceId(String id) {
        return this.instancesMap.get(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringCache.intern(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Set<InstanceInfo> set = this.instances;
        synchronized (set) {
            return this.instances.size();
        }
    }

    public void shuffleAndStoreInstances(boolean filterUpInstances) {
        this._shuffleAndStoreInstances(filterUpInstances, false, null, null, null);
    }

    public void shuffleAndStoreInstances(Map<String, Applications> remoteRegionsRegistry, EurekaClientConfig clientConfig, InstanceRegionChecker instanceRegionChecker) {
        this._shuffleAndStoreInstances(clientConfig.shouldFilterOnlyUpInstances(), true, remoteRegionsRegistry, clientConfig, instanceRegionChecker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _shuffleAndStoreInstances(boolean filterUpInstances, boolean indexByRemoteRegions, @Nullable Map<String, Applications> remoteRegionsRegistry, @Nullable EurekaClientConfig clientConfig, @Nullable InstanceRegionChecker instanceRegionChecker) {
        boolean remoteIndexingActive;
        ArrayList<InstanceInfo> instanceInfoList;
        Set<InstanceInfo> set = this.instances;
        synchronized (set) {
            instanceInfoList = new ArrayList<InstanceInfo>(this.instances);
        }
        boolean bl = remoteIndexingActive = indexByRemoteRegions && null != instanceRegionChecker && null != clientConfig && null != remoteRegionsRegistry;
        if (remoteIndexingActive || filterUpInstances) {
            Iterator it = instanceInfoList.iterator();
            while (it.hasNext()) {
                Application remoteApp;
                String instanceRegion;
                InstanceInfo instanceInfo = (InstanceInfo)it.next();
                if (filterUpInstances && InstanceInfo.InstanceStatus.UP != instanceInfo.getStatus()) {
                    it.remove();
                    continue;
                }
                if (!remoteIndexingActive || instanceRegionChecker.isLocalRegion(instanceRegion = instanceRegionChecker.getInstanceRegion(instanceInfo))) continue;
                Applications appsForRemoteRegion = remoteRegionsRegistry.get(instanceRegion);
                if (null == appsForRemoteRegion) {
                    appsForRemoteRegion = new Applications();
                    remoteRegionsRegistry.put(instanceRegion, appsForRemoteRegion);
                }
                if (null == (remoteApp = appsForRemoteRegion.getRegisteredApplications(instanceInfo.getAppName()))) {
                    remoteApp = new Application(instanceInfo.getAppName());
                    appsForRemoteRegion.addApplication(remoteApp);
                }
                remoteApp.addInstance(instanceInfo);
                this.removeInstance(instanceInfo, false);
                it.remove();
            }
        }
        Collections.shuffle(instanceInfoList, shuffleRandom);
        this.shuffledInstances.set(instanceInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInstance(InstanceInfo i, boolean markAsDirty) {
        this.instancesMap.remove(i.getId());
        Set<InstanceInfo> set = this.instances;
        synchronized (set) {
            this.instances.remove(i);
            if (markAsDirty) {
                this.isDirty = true;
            }
        }
    }
}

