/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.shiro.bean;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.BearerToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class StatelessAuthFilter
extends AccessControlFilter {
    private static final Logger LOG = LoggerFactory.getLogger(StatelessAuthFilter.class);

    protected boolean isAccessAllowed(ServletRequest servletRequest, ServletResponse servletResponse, Object o) {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        if (StringUtils.equals((CharSequence)HttpMethod.OPTIONS.name(), (CharSequence)httpServletRequest.getMethod())) {
            return true;
        }
        String tokenValue = this.getTokenValue(httpServletRequest);
        if (StringUtils.isBlank((CharSequence)tokenValue)) {
            LOG.error("token is null.");
            this.unionFailResponse(servletResponse);
            return false;
        }
        BearerToken token = new BearerToken(tokenValue);
        Subject subject = this.getSubject(servletRequest, servletResponse);
        try {
            subject.login((AuthenticationToken)token);
        }
        catch (Exception e) {
            LOG.error("token is warning. token : {}.", (Object)tokenValue, (Object)e);
            this.unionFailResponse(servletResponse);
            return false;
        }
        return true;
    }

    private String getTokenValue(HttpServletRequest httpServletRequest) {
        String tokenName = "X-Access-Token";
        String tokenValue = httpServletRequest.getHeader(tokenName);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tokenValue})) {
            return tokenValue;
        }
        tokenValue = httpServletRequest.getParameter(tokenName);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tokenValue})) {
            return tokenValue;
        }
        Cookie[] cookies = httpServletRequest.getCookies();
        if (Objects.isNull(cookies)) {
            return "";
        }
        return Arrays.stream(cookies).filter(cookie -> StringUtils.equals((CharSequence)tokenName, (CharSequence)cookie.getName())).findAny().orElse(new Cookie(tokenName, "")).getValue();
    }

    private void unionFailResponse(ServletResponse response) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setContentType("application/json;charset=utf-8");
        httpResponse.setCharacterEncoding("utf-8");
        this.wrapCorsResponse(httpResponse);
        httpResponse.setStatus(401);
        ShenyuAdminResult result = ShenyuAdminResult.error(600, "token is error");
        httpResponse.getWriter().println(GsonUtils.getInstance().toJson((Object)result));
    }

    private void wrapCorsResponse(HttpServletResponse response) {
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
        response.addHeader("Access-Control-Allow-Headers", "Content-Type");
        response.addHeader("Access-Control-Max-Age", "1800");
    }
}

