/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.plugin.BatchNamespacePluginChangedEvent;
import org.apache.shenyu.admin.model.event.plugin.BatchNamespacePluginDeletedEvent;
import org.apache.shenyu.admin.model.event.plugin.NamespacePluginChangedEvent;
import org.apache.shenyu.admin.model.event.plugin.NamespacePluginCreatedEvent;
import org.apache.shenyu.admin.model.vo.NamespacePluginVO;
import org.apache.shenyu.admin.service.publish.AdminDataModelChangedEventPublisher;
import org.apache.shenyu.admin.transfer.PluginTransfer;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class NamespacePluginEventPublisher
implements AdminDataModelChangedEventPublisher<NamespacePluginVO> {
    private final ApplicationEventPublisher publisher;

    public NamespacePluginEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void onCreated(NamespacePluginVO namespacePluginVO) {
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.CREATE, Collections.singletonList(PluginTransfer.INSTANCE.mapToData(namespacePluginVO))));
        this.publish(new NamespacePluginCreatedEvent(namespacePluginVO, SessionUtil.visitorName()));
    }

    @Override
    public void onUpdated(NamespacePluginVO namespacePluginVO, NamespacePluginVO before) {
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.UPDATE, Collections.singletonList(PluginTransfer.INSTANCE.mapToData(namespacePluginVO))));
        this.publish(new NamespacePluginChangedEvent(namespacePluginVO, before, EventTypeEnum.PLUGIN_UPDATE, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(NamespacePluginVO namespacePluginVO) {
        this.publish(new NamespacePluginChangedEvent(namespacePluginVO, null, EventTypeEnum.PLUGIN_DELETE, SessionUtil.visitorName()));
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.DELETE, Stream.of(namespacePluginVO).map(PluginTransfer.INSTANCE::mapToData).collect(Collectors.toList())));
    }

    @Override
    public void onDeleted(Collection<NamespacePluginVO> namespacePlugin) {
        String namespaceId = namespacePlugin.stream().map(NamespacePluginVO.class::cast).findFirst().map(NamespacePluginVO::getNamespaceId).orElse("649330b6-c2d7-4edc-be8e-8a54df9eb385");
        List<PluginDO> pluginDOList = namespacePlugin.stream().map(NamespacePluginVO.class::cast).map(PluginDO::buildPluginDO).collect(Collectors.toList());
        this.publish(new BatchNamespacePluginDeletedEvent(pluginDOList, SessionUtil.visitorName(), namespaceId));
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.DELETE, namespacePlugin.stream().map(PluginTransfer.INSTANCE::mapToData).collect(Collectors.toList())));
    }

    public void onEnabled(Collection<NamespacePluginVO> namespacePlugin) {
        this.publish(new BatchNamespacePluginChangedEvent(namespacePlugin, null, EventTypeEnum.PLUGIN_UPDATE, SessionUtil.visitorName()));
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.UPDATE, namespacePlugin.stream().map(PluginTransfer.INSTANCE::mapToData).collect(Collectors.toList())));
    }

    @Override
    public void publish(AdminDataModelChangedEvent event) {
        this.publisher.publishEvent((ApplicationEvent)event);
    }
}

