/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.constraints.NotNull;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.controller.PagedController;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.InstanceQuery;
import org.apache.shenyu.admin.model.query.InstanceQueryCondition;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.InstanceInfoVO;
import org.apache.shenyu.admin.service.InstanceInfoService;
import org.apache.shenyu.admin.service.PageService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/instance"})
public class InstanceController
implements PagedController<InstanceQueryCondition, InstanceInfoVO> {
    private final InstanceInfoService instanceInfoService;

    public InstanceController(InstanceInfoService instanceInfoService) {
        this.instanceInfoService = instanceInfoService;
    }

    @GetMapping
    public ShenyuAdminResult queryPlugins(@RequestParam(name="instanceType", required=false) String instanceType, @RequestParam(name="instanceIp", required=false) String instanceIp, @RequestParam(name="instancePort", required=false) String instancePort, @RequestParam(name="namespaceId") String namespaceId, @NotNull @RequestParam(name="currentPage") Integer currentPage, @NotNull @RequestParam(name="pageSize") Integer pageSize) {
        CommonPager<InstanceInfoVO> commonPager = this.instanceInfoService.listByPage(new InstanceQuery(new PageParameter(currentPage, pageSize), instanceType, instanceIp, instancePort, namespaceId));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:instance:edit"})
    public ShenyuAdminResult detailInstanceInfo(@PathVariable(value="id") String id) {
        InstanceInfoVO instanceInfoVO = this.instanceInfoService.findById(id);
        return ShenyuAdminResult.success("detail success", instanceInfoVO);
    }

    @Override
    public PageService<InstanceQueryCondition, InstanceInfoVO> pageService() {
        return this.instanceInfoService;
    }
}

