/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Collection;
import java.util.List;
import org.apache.servicecomb.registry.api.Discovery;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.serviceregistry.RegistryUtils;

public class ServiceCenterDiscovery
implements Discovery {
    public static final String NAME = "service center discovery";

    public void init() {
    }

    public void run() {
    }

    public void destroy() {
    }

    public int getOrder() {
        return 100;
    }

    public Microservice getMicroservice(String microserviceId) {
        return RegistryUtils.getMicroservice(microserviceId);
    }

    public List<Microservice> getAllMicroservices() {
        return RegistryUtils.getAllMicroservices();
    }

    public String getSchema(String microserviceId, Collection<MicroserviceInstance> instances, String schemaId) {
        return RegistryUtils.getAggregatedSchema(microserviceId, schemaId);
    }

    public MicroserviceInstance getMicroserviceInstance(String serviceId, String instanceId) {
        return RegistryUtils.getResultFromFirstValidServiceRegistry(sr -> sr.getServiceRegistryClient().findServiceInstance(serviceId, instanceId));
    }

    public MicroserviceInstances findServiceInstances(String appId, String serviceName, String versionRule) {
        return RegistryUtils.findServiceInstances(appId, serviceName, versionRule);
    }

    public String name() {
        return NAME;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.enabled", true).get();
    }
}

