/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DProtocol;
import flash.tools.debugger.concrete.DProtocolNotifierIF;
import java.util.HashMap;
import java.util.Map;

public class DMessageCounter
implements DProtocolNotifierIF {
    long[] m_inCounts = new long[66];
    long[] m_outCounts = new long[58];
    long m_lastIsolate = 1L;
    Object m_isolateLock;
    boolean m_isolate;
    Map<Long, DMessageCounter> m_isolateCounterMap = new HashMap<Long, DMessageCounter>();

    public DMessageCounter() {
        this.m_isolateLock = new Object();
        this.clearArray(this.m_inCounts);
        this.clearArray(this.m_outCounts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected() {
        Object object;
        Object object2 = object = this.getInLock();
        synchronized (object2) {
            object.notifyAll();
        }
        Object object3 = object2 = this.getOutLock();
        synchronized (object3) {
            object2.notifyAll();
        }
    }

    public Object getInLock() {
        return this.m_inCounts;
    }

    public Object getOutLock() {
        return this.m_outCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageSent(DMessage dMessage) {
        DMessageCounter dMessageCounter;
        Object object;
        int n = dMessage.getType();
        if (n < 0 || n >= 57) {
            n = 57;
        }
        long l = dMessage.getTargetIsolate();
        Object object2 = this.getOutLock();
        if (!this.m_isolate) {
            object = this.m_isolateLock;
            synchronized (object) {
                if (this.m_lastIsolate != 1L) {
                    dMessageCounter = this.m_isolateCounterMap.get(this.m_lastIsolate);
                    object2 = dMessageCounter.getOutLock();
                }
            }
        }
        object = object2;
        synchronized (object) {
            if (!this.m_isolate && l != 1L) {
                dMessageCounter = this.m_isolateCounterMap.get(l);
                dMessageCounter.messageSent(dMessage);
                int n2 = n;
                this.m_outCounts[n2] = this.m_outCounts[n2] + 1L;
                object2.notifyAll();
            } else {
                int n3 = n;
                this.m_outCounts[n3] = this.m_outCounts[n3] + 1L;
                object2.notifyAll();
            }
        }
    }

    public void setIsolate(boolean bl) {
        this.m_isolate = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(DMessage dMessage, DProtocol dProtocol) {
        DMessageCounter dMessageCounter;
        Object object;
        int n = dMessage.getType();
        if (n < 0 || n >= 65) {
            n = 65;
        }
        Object object2 = this.getInLock();
        if (!this.m_isolate) {
            object = this.m_isolateLock;
            synchronized (object) {
                if (this.m_lastIsolate != 1L) {
                    dMessageCounter = this.m_isolateCounterMap.get(this.m_lastIsolate);
                    object2 = dMessageCounter.getInLock();
                }
            }
        }
        object = object2;
        synchronized (object) {
            if (n == 62) {
                Object object3;
                long l = dMessage.getDWord();
                if (l != 1L && !this.m_isolateCounterMap.containsKey(l)) {
                    object3 = new DMessageCounter();
                    ((DMessageCounter)object3).setIsolate(true);
                    this.m_isolateCounterMap.put(l, (DMessageCounter)object3);
                }
                object3 = this.m_isolateLock;
                synchronized (object3) {
                    this.m_lastIsolate = l;
                }
                int n2 = n;
                this.m_inCounts[n2] = this.m_inCounts[n2] + 1L;
                object2.notifyAll();
            } else if (!this.m_isolate && this.m_lastIsolate != 1L) {
                dMessageCounter = this.m_isolateCounterMap.get(this.m_lastIsolate);
                dMessageCounter.messageArrived(dMessage, dProtocol);
                Object object4 = dMessageCounter.getInLock();
                synchronized (object4) {
                    dMessageCounter.getInLock().notifyAll();
                }
            } else {
                int n3 = n;
                this.m_inCounts[n3] = this.m_inCounts[n3] + 1L;
                object2.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInCount(int n) {
        Object object = this.getInLock();
        synchronized (object) {
            return this.m_inCounts[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOutCount(int n) {
        Object object = this.getOutLock();
        synchronized (object) {
            return this.m_outCounts[n];
        }
    }

    public long getIsolateInCount(long l, int n) {
        DMessageCounter dMessageCounter = this.m_isolateCounterMap.get(l);
        return dMessageCounter.getInCount(n);
    }

    public long getIsolateOutCount(long l, int n) {
        DMessageCounter dMessageCounter = this.m_isolateCounterMap.get(l);
        return dMessageCounter.getOutCount(n);
    }

    public Object getIsolateInLock(long l) {
        DMessageCounter dMessageCounter = this.m_isolateCounterMap.get(l);
        return dMessageCounter.getInLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInCounts() {
        Object object = this.getInLock();
        synchronized (object) {
            this.clearArray(this.m_inCounts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOutCounts() {
        Object object = this.getOutLock();
        synchronized (object) {
            this.clearArray(this.m_outCounts);
        }
    }

    void clearArray(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = 0L;
        }
    }
}

